# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAnnouncementsItems(BaseModel):
    """
    GetAnnouncementsItems

    Attributes:
        ann_id (int): Announcement ID
        ann_title (str): Announcement title
        ann_type (list[str]): Announcement type
        ann_desc (str): Announcement description
        c_time (int): Announcement release time, Unix millisecond timestamp format
        language (str): language type
        ann_url (str): Announcement link
    """

    ann_id: Optional[int] = Field(default=None,
                                  description="Announcement ID",
                                  alias="annId")
    ann_title: Optional[str] = Field(default=None,
                                     description="Announcement title",
                                     alias="annTitle")
    ann_type: Optional[List[str]] = Field(default=None,
                                          description="Announcement type",
                                          alias="annType")
    ann_desc: Optional[str] = Field(default=None,
                                    description="Announcement description",
                                    alias="annDesc")
    c_time: Optional[int] = Field(
        default=None,
        description=
        "Announcement release time, Unix millisecond timestamp format",
        alias="cTime")
    language: Optional[str] = Field(default=None, description="language type")
    ann_url: Optional[str] = Field(default=None,
                                   description="Announcement link",
                                   alias="annUrl")

    __properties: ClassVar[List[str]] = [
        "annId", "annTitle", "annType", "annDesc", "cTime", "language",
        "annUrl"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAnnouncementsItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAnnouncementsItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "annId": obj.get("annId"),
            "annTitle": obj.get("annTitle"),
            "annType": obj.get("annType"),
            "annDesc": obj.get("annDesc"),
            "cTime": obj.get("cTime"),
            "language": obj.get("language"),
            "annUrl": obj.get("annUrl")
        })
        return _obj
