# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_announcements_items import GetAnnouncementsItems
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetAnnouncementsResp(BaseModel, Response):
    """
    GetAnnouncementsResp

    Attributes:
        total_num (int): Total Number
        items (list[GetAnnouncementsItems]): 
        current_page (int): Current page
        page_size (int): Page size
        total_page (int): Total Page
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    total_num: Optional[int] = Field(default=None,
                                     description="Total Number",
                                     alias="totalNum")
    items: Optional[List[GetAnnouncementsItems]] = None
    current_page: Optional[int] = Field(default=None,
                                        description="Current page",
                                        alias="currentPage")
    page_size: Optional[int] = Field(default=None,
                                     description="Page size",
                                     alias="pageSize")
    total_page: Optional[int] = Field(default=None,
                                      description="Total Page",
                                      alias="totalPage")

    __properties: ClassVar[List[str]] = [
        "totalNum", "items", "currentPage", "pageSize", "totalPage"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAnnouncementsResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAnnouncementsResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalNum":
            obj.get("totalNum"),
            "items":
            [GetAnnouncementsItems.from_dict(_item) for _item in obj["items"]]
            if obj.get("items") is not None else None,
            "currentPage":
            obj.get("currentPage"),
            "pageSize":
            obj.get("pageSize"),
            "totalPage":
            obj.get("totalPage")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
