# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetCurrencyReq(BaseModel):
    """
    GetCurrencyReq

    Attributes:
        currency (str): Path parameter, Currency
        chain (str): Support for querying the chain of currency, e.g. The available value for USDT are OMNI, ERC20, TRC20. This only apply for multi-chain currency, and there is no need for single chain currency.
    """

    currency: Optional[str] = Field(default=None,
                                    path_variable="True",
                                    description="Path parameter, Currency")
    chain: Optional[str] = Field(
        default=None,
        description=
        "Support for querying the chain of currency, e.g. The available value for USDT are OMNI, ERC20, TRC20. This only apply for multi-chain currency, and there is no need for single chain currency."
    )

    __properties: ClassVar[List[str]] = ["currency", "chain"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetCurrencyReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetCurrencyReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "chain": obj.get("chain")
        })
        return _obj


class GetCurrencyReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetCurrencyReqBuilder:
        """
        Path parameter, Currency
        """
        self.obj['currency'] = value
        return self

    def set_chain(self, value: str) -> GetCurrencyReqBuilder:
        """
        Support for querying the chain of currency, e.g. The available value for USDT are OMNI, ERC20, TRC20. This only apply for multi-chain currency, and there is no need for single chain currency.
        """
        self.obj['chain'] = value
        return self

    def build(self) -> GetCurrencyReq:
        return GetCurrencyReq(**self.obj)
