# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetServiceStatusResp(BaseModel, Response):
    """
    GetServiceStatusResp

    Attributes:
        status (StatusEnum): Status of service: open：normal transaction, close：Stop Trading/Maintenance, cancelonly：can only cancel the order but not place order
        msg (str): Remark for operation
    """

    class StatusEnum(Enum):
        """
        Attributes:
            OPEN: normal transaction
            CLOSE: Stop Trading/Maintenance
            CANCELONLY: can only cancel the order but not place order
        """
        OPEN = 'open'
        CLOSE = 'close'
        CANCELONLY = 'cancelonly'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Status of service: open：normal transaction, close：Stop Trading/Maintenance, cancelonly：can only cancel the order but not place order"
    )
    msg: Optional[str] = Field(default=None,
                               description="Remark for operation")

    __properties: ClassVar[List[str]] = ["status", "msg"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetServiceStatusResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetServiceStatusResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "msg": obj.get("msg")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
