# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetStopOrdersListReq(BaseModel):
    """
    GetStopOrdersListReq

    Attributes:
        symbol (str): Only list orders for a specific symbol
        side (SideEnum): buy or sell
        type (TypeEnum): limit, market, limit_stop or market_stop
        trade_type (TradeTypeEnum): The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE
        start_at (float): Start time (milisecond)
        end_at (float): End time (milisecond)
        current_page (int): current page
        order_ids (str): comma seperated order ID list
        page_size (int): page size
        stop (str): Order type: stop: stop loss order, oco: oco order
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: 
            SELL: 
        """
        BUY = 'buy'
        SELL = 'sell'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: 
            MARKET: 
            LIMIT_STOP: 
            MARKET_STOP: 
        """
        LIMIT = 'limit'
        MARKET = 'market'
        LIMIT_STOP = 'limit_stop'
        MARKET_STOP = 'market_stop'

    class TradeTypeEnum(Enum):
        """
        Attributes:
            TRADE: 
            MARGIN_TRADE: 
            MARGIN_ISOLATED_TRADE: 
        """
        TRADE = 'TRADE'
        MARGIN_TRADE = 'MARGIN_TRADE'
        MARGIN_ISOLATED_TRADE = 'MARGIN_ISOLATED_TRADE'

    symbol: Optional[str] = Field(
        default=None, description="Only list orders for a specific symbol")
    side: Optional[SideEnum] = Field(default=None, description="buy or sell")
    type: Optional[TypeEnum] = Field(
        default=None, description="limit, market, limit_stop or market_stop")
    trade_type: Optional[TradeTypeEnum] = Field(
        default=None,
        description=
        "The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE",
        alias="tradeType")
    start_at: Optional[float] = Field(default=None,
                                      description="Start time (milisecond)",
                                      alias="startAt")
    end_at: Optional[float] = Field(default=None,
                                    description="End time (milisecond)",
                                    alias="endAt")
    current_page: Optional[int] = Field(default=None,
                                        description="current page",
                                        alias="currentPage")
    order_ids: Optional[str] = Field(
        default=None,
        description="comma seperated order ID list",
        alias="orderIds")
    page_size: Optional[int] = Field(default=None,
                                     description="page size",
                                     alias="pageSize")
    stop: Optional[str] = Field(
        default=None,
        description="Order type: stop: stop loss order, oco: oco order")

    __properties: ClassVar[List[str]] = [
        "symbol", "side", "type", "tradeType", "startAt", "endAt",
        "currentPage", "orderIds", "pageSize", "stop"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetStopOrdersListReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetStopOrdersListReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "side": obj.get("side"),
            "type": obj.get("type"),
            "tradeType": obj.get("tradeType"),
            "startAt": obj.get("startAt"),
            "endAt": obj.get("endAt"),
            "currentPage": obj.get("currentPage"),
            "orderIds": obj.get("orderIds"),
            "pageSize": obj.get("pageSize"),
            "stop": obj.get("stop")
        })
        return _obj


class GetStopOrdersListReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        Only list orders for a specific symbol
        """
        self.obj['symbol'] = value
        return self

    def set_side(
            self, value: GetStopOrdersListReq.SideEnum
    ) -> GetStopOrdersListReqBuilder:
        """
        buy or sell
        """
        self.obj['side'] = value
        return self

    def set_type(
            self, value: GetStopOrdersListReq.TypeEnum
    ) -> GetStopOrdersListReqBuilder:
        """
        limit, market, limit_stop or market_stop
        """
        self.obj['type'] = value
        return self

    def set_trade_type(
        self, value: GetStopOrdersListReq.TradeTypeEnum
    ) -> GetStopOrdersListReqBuilder:
        """
        The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE
        """
        self.obj['tradeType'] = value
        return self

    def set_start_at(self, value: float) -> GetStopOrdersListReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: float) -> GetStopOrdersListReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetStopOrdersListReqBuilder:
        """
        current page
        """
        self.obj['currentPage'] = value
        return self

    def set_order_ids(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        comma seperated order ID list
        """
        self.obj['orderIds'] = value
        return self

    def set_page_size(self, value: int) -> GetStopOrdersListReqBuilder:
        """
        page size
        """
        self.obj['pageSize'] = value
        return self

    def set_stop(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        Order type: stop: stop loss order, oco: oco order
        """
        self.obj['stop'] = value
        return self

    def build(self) -> GetStopOrdersListReq:
        return GetStopOrdersListReq(**self.obj)
