# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class OrderV1Event(BaseModel):
    """
    OrderV1Event

    Attributes:
        canceled_size (str): Cumulative number of cancellations
        client_oid (str): Client Order Id，The ClientOid field is a unique ID created by the user
        filled_size (str): Cumulative number of filled
        order_id (str): The unique order id generated by the trading system
        order_time (int): Order time(millisecond)
        order_type (OrderTypeEnum): User-specified order type
        origin_size (str): User-specified order size
        price (str): Specify price for currency
        remain_funds (str): Remain funds
        remain_size (str): Remain size
        side (SideEnum): buy or sell
        size (str): User-specified order size
        status (StatusEnum): Order Status
        symbol (str): Symbol
        ts (int): Push time(Nanosecond)
        type (TypeEnum): Order Type
        old_size (str): The size before order update
        fee_type (FeeTypeEnum): Actual Fee Type
        liquidity (LiquidityEnum): Actual transaction order type, If the counterparty order is an [Hidden/Iceberg Order](https://www.kucoin.com/docs-new/doc-338146), even if it is a maker order, this param will be displayed as taker. For actual trading fee, please refer to the **feeType** 
        match_price (str): Match Price (when the type is \"match\")
        match_size (str): Match Size (when the type is \"match\")
        trade_id (str): Trade id, it is generated by Matching engine.
    """

    class OrderTypeEnum(Enum):
        """
        Attributes:
            LIMIT: limit
            MARKET: market
        """
        LIMIT = 'limit'
        MARKET = 'market'

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class StatusEnum(Enum):
        """
        Attributes:
            NEW: the order enters the matching system
            OPEN: the order is in the order book（maker order）
            MATCH: when taker order executes with orders in the order book, the taker order status is “match”
            DONE: the order is fully executed successfully
        """
        NEW = 'new'
        OPEN = 'open'
        MATCH = 'match'
        DONE = 'done'

    class TypeEnum(Enum):
        """
        Attributes:
            OPEN: the order is in the order book（maker order）
            MATCH: the message sent when the order is match,  1. When the status is open and the type is match, it is a maker match.  2. When the status is match and the type is match, it is a taker match.
            UPDATE: The message sent due to the order being modified: STP triggering, partial cancellation of the order. Includes these three situations:  1. When the status is open and the type is update: partial amounts of the order have been canceled, or STP triggers  2. When the status is match and the type is update: STP triggers  3. When the status is done and the type is update: partial amounts of the order have been filled and the unfilled part got canceled, or STP is triggered.
            FILLED: The message sent when the status of the order changes to DONE after the transaction
            CANCELED: The message sent when the status of the order changes to DONE due to being canceled
        """
        OPEN = 'open'
        MATCH = 'match'
        UPDATE = 'update'
        FILLED = 'filled'
        CANCELED = 'canceled'

    class FeeTypeEnum(Enum):
        """
        Attributes:
            TAKER_FEE: takerFee
            MAKER_FEE: makerFee
        """
        TAKER_FEE = 'takerFee'
        MAKER_FEE = 'makerFee'

    class LiquidityEnum(Enum):
        """
        Attributes:
            TAKER: taker
            MAKER: maker
        """
        TAKER = 'taker'
        MAKER = 'maker'

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    canceled_size: Optional[str] = Field(
        default=None,
        description="Cumulative number of cancellations",
        alias="canceledSize")
    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Client Order Id，The ClientOid field is a unique ID created by the user",
        alias="clientOid")
    filled_size: Optional[str] = Field(
        default=None,
        description="Cumulative number of filled",
        alias="filledSize")
    order_id: Optional[str] = Field(
        default=None,
        description="The unique order id generated by the trading system",
        alias="orderId")
    order_time: Optional[int] = Field(default=None,
                                      description="Order time(millisecond)",
                                      alias="orderTime")
    order_type: Optional[OrderTypeEnum] = Field(
        default=None,
        description="User-specified order type",
        alias="orderType")
    origin_size: Optional[str] = Field(default=None,
                                       description="User-specified order size",
                                       alias="originSize")
    price: Optional[str] = Field(default=None,
                                 description="Specify price for currency")
    remain_funds: Optional[str] = Field(default=None,
                                        description="Remain funds",
                                        alias="remainFunds")
    remain_size: Optional[str] = Field(default=None,
                                       description="Remain size",
                                       alias="remainSize")
    side: Optional[SideEnum] = Field(default=None, description="buy or sell")
    size: Optional[str] = Field(default=None,
                                description="User-specified order size")
    status: Optional[StatusEnum] = Field(default=None,
                                         description="Order Status")
    symbol: Optional[str] = Field(default=None, description="Symbol")
    ts: Optional[int] = Field(default=None,
                              description="Push time(Nanosecond)")
    type: Optional[TypeEnum] = Field(default=None, description="Order Type")
    old_size: Optional[str] = Field(default=None,
                                    description="The size before order update",
                                    alias="oldSize")
    fee_type: Optional[FeeTypeEnum] = Field(default=None,
                                            description="Actual Fee Type",
                                            alias="feeType")
    liquidity: Optional[LiquidityEnum] = Field(
        default=None,
        description=
        "Actual transaction order type, If the counterparty order is an [Hidden/Iceberg Order](https://www.kucoin.com/docs-new/doc-338146), even if it is a maker order, this param will be displayed as taker. For actual trading fee, please refer to the **feeType** "
    )
    match_price: Optional[str] = Field(
        default=None,
        description="Match Price (when the type is \"match\")",
        alias="matchPrice")
    match_size: Optional[str] = Field(
        default=None,
        description="Match Size (when the type is \"match\")",
        alias="matchSize")
    trade_id: Optional[str] = Field(
        default=None,
        description="Trade id, it is generated by Matching engine.",
        alias="tradeId")

    __properties: ClassVar[List[str]] = [
        "canceledSize", "clientOid", "filledSize", "orderId", "orderTime",
        "orderType", "originSize", "price", "remainFunds", "remainSize",
        "side", "size", "status", "symbol", "ts", "type", "oldSize", "feeType",
        "liquidity", "matchPrice", "matchSize", "tradeId"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[OrderV1Event]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[OrderV1Event]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "canceledSize": obj.get("canceledSize"),
            "clientOid": obj.get("clientOid"),
            "filledSize": obj.get("filledSize"),
            "orderId": obj.get("orderId"),
            "orderTime": obj.get("orderTime"),
            "orderType": obj.get("orderType"),
            "originSize": obj.get("originSize"),
            "price": obj.get("price"),
            "remainFunds": obj.get("remainFunds"),
            "remainSize": obj.get("remainSize"),
            "side": obj.get("side"),
            "size": obj.get("size"),
            "status": obj.get("status"),
            "symbol": obj.get("symbol"),
            "ts": obj.get("ts"),
            "type": obj.get("type"),
            "oldSize": obj.get("oldSize"),
            "feeType": obj.get("feeType"),
            "liquidity": obj.get("liquidity"),
            "matchPrice": obj.get("matchPrice"),
            "matchSize": obj.get("matchSize"),
            "tradeId": obj.get("tradeId")
        })
        return _obj


OrderV1EventCallback = Callable[[str, str, OrderV1Event], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (OrderV1Event): event data
"""


class OrderV1EventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: OrderV1EventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = OrderV1Event.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
