# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketService
from .model_account_event import AccountEventCallback, AccountEventCallbackWrapper
from .model_order_v1_event import OrderV1EventCallback, OrderV1EventCallbackWrapper
from .model_order_v2_event import OrderV2EventCallback, OrderV2EventCallbackWrapper


class SpotPrivateWS(ABC):

    @abstractmethod
    def account(self, callback: AccountEventCallback) -> str:
        """
        summary: Get Account Balance
        description: You will receive this message when an account balance changes. The message contains the details of the change.
        push frequency: real-time
        """
        pass

    @abstractmethod
    def order_v1(self, callback: OrderV1EventCallback) -> str:
        """
        summary: Get Order(V1)
        description: This topic will push all change events of your orders.
        push frequency: real-time
        """
        pass

    @abstractmethod
    def order_v2(self, callback: OrderV2EventCallback) -> str:
        """
        summary: Get Order(V2)
        description: This topic will push all change events of your orders. Compared with v1, v2 adds an Order Status: \&quot;new\&quot;, there is no difference in push speed
        push frequency: real-time
        """
        pass

    @abstractmethod
    def unsubscribe(self, id: str):
        pass

    @abstractmethod
    def start(self):
        pass

    @abstractmethod
    def stop(self):
        pass


class SpotPrivateWSImpl(SpotPrivateWS):

    def __init__(self, transport: WebSocketService):
        self.transport = transport

    def account(self, callback: AccountEventCallback) -> str:
        topic_prefix = "/account/balance"

        args = []

        return self.transport.subscribe(topic_prefix, args,
                                        AccountEventCallbackWrapper(callback))

    def order_v1(self, callback: OrderV1EventCallback) -> str:
        topic_prefix = "/spotMarket/tradeOrders"

        args = []

        return self.transport.subscribe(topic_prefix, args,
                                        OrderV1EventCallbackWrapper(callback))

    def order_v2(self, callback: OrderV2EventCallback) -> str:
        topic_prefix = "/spotMarket/tradeOrdersV2"

        args = []

        return self.transport.subscribe(topic_prefix, args,
                                        OrderV2EventCallbackWrapper(callback))

    def unsubscribe(self, id: str):
        self.transport.unsubscribe(id)

    def start(self):
        self.transport.start()

    def stop(self):
        self.transport.stop()
