# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from .model_orderbook_increment_changes import OrderbookIncrementChanges
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class OrderbookIncrementEvent(BaseModel):
    """
    OrderbookIncrementEvent

    Attributes:
        changes (OrderbookIncrementChanges): 
        sequence_end (int): 
        sequence_start (int): 
        symbol (str): 
        time (int): milliseconds
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    changes: Optional[OrderbookIncrementChanges] = None
    sequence_end: Optional[int] = Field(default=None, alias="sequenceEnd")
    sequence_start: Optional[int] = Field(default=None, alias="sequenceStart")
    symbol: Optional[str] = None
    time: Optional[int] = Field(default=None, description="milliseconds")

    __properties: ClassVar[List[str]] = [
        "changes", "sequenceEnd", "sequenceStart", "symbol", "time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[OrderbookIncrementEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of changes
        if self.changes:
            _dict['changes'] = self.changes.to_dict()
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[OrderbookIncrementEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "changes":
            OrderbookIncrementChanges.from_dict(obj["changes"])
            if obj.get("changes") is not None else None,
            "sequenceEnd":
            obj.get("sequenceEnd"),
            "sequenceStart":
            obj.get("sequenceStart"),
            "symbol":
            obj.get("symbol"),
            "time":
            obj.get("time")
        })
        return _obj


OrderbookIncrementEventCallback = Callable[[str, str, OrderbookIncrementEvent],
                                           None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (OrderbookIncrementEvent): event data
"""


class OrderbookIncrementEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: OrderbookIncrementEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = OrderbookIncrementEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
