# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAccountsData(BaseModel):
    """
    GetAccountsData

    Attributes:
        uid (str): UID
        margin_ccy (str): Margin Currency
        margin_qty (str): Maintenance Quantity (Calculated with Margin Coefficient)
        margin_factor (str): Margin Coefficient
        account_type (str): Account Type: TRADE - Trading Account CONTRACT - Futures Account (for Total Futures Equity)
        is_parent (bool): If It Is Master Account
    """

    uid: Optional[str] = Field(default=None, description="UID")
    margin_ccy: Optional[str] = Field(default=None,
                                      description="Margin Currency",
                                      alias="marginCcy")
    margin_qty: Optional[str] = Field(
        default=None,
        description="Maintenance Quantity (Calculated with Margin Coefficient)",
        alias="marginQty")
    margin_factor: Optional[str] = Field(default=None,
                                         description="Margin Coefficient",
                                         alias="marginFactor")
    account_type: Optional[str] = Field(
        default=None,
        description=
        "Account Type: TRADE - Trading Account CONTRACT - Futures Account (for Total Futures Equity)",
        alias="accountType")
    is_parent: Optional[bool] = Field(default=None,
                                      description="If It Is Master Account",
                                      alias="isParent")

    __properties: ClassVar[List[str]] = [
        "uid", "marginCcy", "marginQty", "marginFactor", "accountType",
        "isParent"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAccountsData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetAccountsData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "marginCcy": obj.get("marginCcy"),
            "marginQty": obj.get("marginQty"),
            "marginFactor": obj.get("marginFactor"),
            "accountType": obj.get("accountType"),
            "isParent": obj.get("isParent")
        })
        return _obj
