# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_cross_margin_account_accounts import GetCrossMarginAccountAccounts
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetCrossMarginAccountResp(BaseModel, Response):
    """
    GetCrossMarginAccountResp

    Attributes:
        total_asset_of_quote_currency (str): Total Assets in Quote Currency
        total_liability_of_quote_currency (str): Total Liability in Quote Currency
        debt_ratio (str): debt ratio
        status (StatusEnum): Position status; EFFECTIVE-effective, BANKRUPTCY-bankruptcy liquidation, LIQUIDATION-closing, REPAY-repayment, BORROW borrowing
        accounts (list[GetCrossMarginAccountAccounts]): Margin account list
    """

    class StatusEnum(Enum):
        """
        Attributes:
            EFFECTIVE: Effective
            BANKRUPTCY: Bankruptcy liquidation
            LIQUIDATION: Closing
            REPAY: Repayment
            BORROW: Borrowing
        """
        EFFECTIVE = 'EFFECTIVE'
        BANKRUPTCY = 'BANKRUPTCY'
        LIQUIDATION = 'LIQUIDATION'
        REPAY = 'REPAY'
        BORROW = 'BORROW'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    total_asset_of_quote_currency: Optional[str] = Field(
        default=None,
        description="Total Assets in Quote Currency",
        alias="totalAssetOfQuoteCurrency")
    total_liability_of_quote_currency: Optional[str] = Field(
        default=None,
        description="Total Liability in Quote Currency",
        alias="totalLiabilityOfQuoteCurrency")
    debt_ratio: Optional[str] = Field(default=None,
                                      description="debt ratio",
                                      alias="debtRatio")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Position status; EFFECTIVE-effective, BANKRUPTCY-bankruptcy liquidation, LIQUIDATION-closing, REPAY-repayment, BORROW borrowing"
    )
    accounts: Optional[List[GetCrossMarginAccountAccounts]] = Field(
        default=None, description="Margin account list")

    __properties: ClassVar[List[str]] = [
        "totalAssetOfQuoteCurrency", "totalLiabilityOfQuoteCurrency",
        "debtRatio", "status", "accounts"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetCrossMarginAccountResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetCrossMarginAccountResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalAssetOfQuoteCurrency":
            obj.get("totalAssetOfQuoteCurrency"),
            "totalLiabilityOfQuoteCurrency":
            obj.get("totalLiabilityOfQuoteCurrency"),
            "debtRatio":
            obj.get("debtRatio"),
            "status":
            obj.get("status"),
            "accounts": [
                GetCrossMarginAccountAccounts.from_dict(_item)
                for _item in obj["accounts"]
            ] if obj.get("accounts") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
