# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetFuturesLedgerDataList(BaseModel):
    """
    GetFuturesLedgerDataList

    Attributes:
        time (int): ledger time
        type (str): Type: RealisedPNL, Deposit, Withdrawal, TransferIn, TransferOut
        amount (float): Transaction amount
        fee (float): Fee
        account_equity (float): Account equity
        status (str): Status: Completed, Pending
        remark (str): Ticker symbol of the contract
        offset (int): Offset
        currency (str): Currency
    """

    time: Optional[int] = Field(default=None, description="ledger time")
    type: Optional[str] = Field(
        default=None,
        description=
        "Type: RealisedPNL, Deposit, Withdrawal, TransferIn, TransferOut")
    amount: Optional[float] = Field(default=None,
                                    description="Transaction amount")
    fee: Optional[float] = Field(default=None, description="Fee")
    account_equity: Optional[float] = Field(default=None,
                                            description="Account equity",
                                            alias="accountEquity")
    status: Optional[str] = Field(default=None,
                                  description="Status: Completed, Pending")
    remark: Optional[str] = Field(default=None,
                                  description="Ticker symbol of the contract")
    offset: Optional[int] = Field(default=None, description="Offset")
    currency: Optional[str] = Field(default=None, description="Currency")

    __properties: ClassVar[List[str]] = [
        "time", "type", "amount", "fee", "accountEquity", "status", "remark",
        "offset", "currency"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetFuturesLedgerDataList]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetFuturesLedgerDataList]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "time": obj.get("time"),
            "type": obj.get("type"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "accountEquity": obj.get("accountEquity"),
            "status": obj.get("status"),
            "remark": obj.get("remark"),
            "offset": obj.get("offset"),
            "currency": obj.get("currency")
        })
        return _obj
