# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_isolated_margin_account_detail_v1_base_asset import GetIsolatedMarginAccountDetailV1BaseAsset
from .model_get_isolated_margin_account_detail_v1_quote_asset import GetIsolatedMarginAccountDetailV1QuoteAsset
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetIsolatedMarginAccountDetailV1Resp(BaseModel, Response):
    """
    GetIsolatedMarginAccountDetailV1Resp

    Attributes:
        symbol (str): Symbol
        status (StatusEnum): The position status: Existing liabilities-DEBT, No liabilities-CLEAR, Bankrupcy (after position enters a negative balance)-BANKRUPTCY, Existing borrowings-IN_BORROW, Existing repayments-IN_REPAY, Under liquidation-IN_LIQUIDATION, Under auto-renewal assets-IN_AUTO_RENEW .
        debt_ratio (str): debt ratio
        base_asset (GetIsolatedMarginAccountDetailV1BaseAsset): 
        quote_asset (GetIsolatedMarginAccountDetailV1QuoteAsset): 
    """

    class StatusEnum(Enum):
        """
        Attributes:
            DEBT: 
            CLEAR: 
            BANKRUPTCY: 
            IN_BORROW: 
            IN_REPAY: 
            IN_LIQUIDATION: 
            IN_AUTO_RENEW: 
        """
        DEBT = 'DEBT'
        CLEAR = 'CLEAR'
        BANKRUPTCY = 'BANKRUPTCY'
        IN_BORROW = 'IN_BORROW'
        IN_REPAY = 'IN_REPAY'
        IN_LIQUIDATION = 'IN_LIQUIDATION'
        IN_AUTO_RENEW = 'IN_AUTO_RENEW'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    symbol: Optional[str] = Field(default=None, description="Symbol")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "The position status: Existing liabilities-DEBT, No liabilities-CLEAR, Bankrupcy (after position enters a negative balance)-BANKRUPTCY, Existing borrowings-IN_BORROW, Existing repayments-IN_REPAY, Under liquidation-IN_LIQUIDATION, Under auto-renewal assets-IN_AUTO_RENEW ."
    )
    debt_ratio: Optional[str] = Field(default=None,
                                      description="debt ratio",
                                      alias="debtRatio")
    base_asset: Optional[GetIsolatedMarginAccountDetailV1BaseAsset] = Field(
        default=None, alias="baseAsset")
    quote_asset: Optional[GetIsolatedMarginAccountDetailV1QuoteAsset] = Field(
        default=None, alias="quoteAsset")

    __properties: ClassVar[List[str]] = [
        "symbol", "status", "debtRatio", "baseAsset", "quoteAsset"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls,
            json_str: str) -> Optional[GetIsolatedMarginAccountDetailV1Resp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of base_asset
        if self.base_asset:
            _dict['baseAsset'] = self.base_asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quote_asset
        if self.quote_asset:
            _dict['quoteAsset'] = self.quote_asset.to_dict()
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetIsolatedMarginAccountDetailV1Resp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "status":
            obj.get("status"),
            "debtRatio":
            obj.get("debtRatio"),
            "baseAsset":
            GetIsolatedMarginAccountDetailV1BaseAsset.from_dict(
                obj["baseAsset"])
            if obj.get("baseAsset") is not None else None,
            "quoteAsset":
            GetIsolatedMarginAccountDetailV1QuoteAsset.from_dict(
                obj["quoteAsset"])
            if obj.get("quoteAsset") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
