# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotAccountListData(BaseModel):
    """
    GetSpotAccountListData

    Attributes:
        id (str): Account ID
        currency (str): Currency
        type (TypeEnum): Account type:，main、trade、isolated(abandon)、margin(abandon) 
        balance (str): Total funds in the account
        available (str): Funds available to withdraw or trade
        holds (str): Funds on hold (not available for use)
    """

    class TypeEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
        """
        MAIN = 'main'
        TRADE = 'trade'

    id: Optional[str] = Field(default=None, description="Account ID")
    currency: Optional[str] = Field(default=None, description="Currency")
    type: Optional[TypeEnum] = Field(
        default=None,
        description=
        "Account type:，main、trade、isolated(abandon)、margin(abandon) ")
    balance: Optional[str] = Field(default=None,
                                   description="Total funds in the account")
    available: Optional[str] = Field(
        default=None, description="Funds available to withdraw or trade")
    holds: Optional[str] = Field(
        default=None, description="Funds on hold (not available for use)")

    __properties: ClassVar[List[str]] = [
        "id", "currency", "type", "balance", "available", "holds"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotAccountListData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSpotAccountListData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "currency": obj.get("currency"),
            "type": obj.get("type"),
            "balance": obj.get("balance"),
            "available": obj.get("available"),
            "holds": obj.get("holds")
        })
        return _obj
