# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotLedgerItems(BaseModel):
    """
    GetSpotLedgerItems

    Attributes:
        id (str): unique id
        currency (str): The currency of an account
        amount (str): The total amount of assets (fees included) involved in assets changes such as transaction, withdrawal and bonus distribution.
        fee (str): Fees generated in transaction, withdrawal, etc.
        balance (str): Remaining funds after the transaction.
        account_type (str): The account type of the master user: MAIN, TRADE, MARGIN or CONTRACT.
        biz_type (str): Business type leading to the changes in funds, such as exchange, withdrawal, deposit, KUCOIN_BONUS, REFERRAL_BONUS, Lendings etc.
        direction (str): Side, out or in
        created_at (int): Time of the event
        context (str): Business related information such as order ID, serial No., etc.
    """

    id: Optional[str] = Field(default=None, description="unique id")
    currency: Optional[str] = Field(default=None,
                                    description="The currency of an account")
    amount: Optional[str] = Field(
        default=None,
        description=
        "The total amount of assets (fees included) involved in assets changes such as transaction, withdrawal and bonus distribution."
    )
    fee: Optional[str] = Field(
        default=None,
        description="Fees generated in transaction, withdrawal, etc.")
    balance: Optional[str] = Field(
        default=None, description="Remaining funds after the transaction.")
    account_type: Optional[str] = Field(
        default=None,
        description=
        "The account type of the master user: MAIN, TRADE, MARGIN or CONTRACT.",
        alias="accountType")
    biz_type: Optional[str] = Field(
        default=None,
        description=
        "Business type leading to the changes in funds, such as exchange, withdrawal, deposit, KUCOIN_BONUS, REFERRAL_BONUS, Lendings etc.",
        alias="bizType")
    direction: Optional[str] = Field(default=None,
                                     description="Side, out or in")
    created_at: Optional[int] = Field(default=None,
                                      description="Time of the event",
                                      alias="createdAt")
    context: Optional[str] = Field(
        default=None,
        description=
        "Business related information such as order ID, serial No., etc.")

    __properties: ClassVar[List[str]] = [
        "id", "currency", "amount", "fee", "balance", "accountType", "bizType",
        "direction", "createdAt", "context"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotLedgerItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSpotLedgerItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "fee": obj.get("fee"),
            "balance": obj.get("balance"),
            "accountType": obj.get("accountType"),
            "bizType": obj.get("bizType"),
            "direction": obj.get("direction"),
            "createdAt": obj.get("createdAt"),
            "context": obj.get("context")
        })
        return _obj
