# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetDepositAddressV3Req(BaseModel):
    """
    GetDepositAddressV3Req

    Attributes:
        currency (str): currency
        amount (str): Deposit amount. This parameter is only used when applying for invoices on the Lightning Network. This parameter is invalid if it is not passed through the Lightning Network.
        chain (str): The chain Id of currency.
    """

    currency: Optional[str] = Field(default=None, description="currency")
    amount: Optional[str] = Field(
        default=None,
        description=
        "Deposit amount. This parameter is only used when applying for invoices on the Lightning Network. This parameter is invalid if it is not passed through the Lightning Network."
    )
    chain: Optional[str] = Field(default=None,
                                 description="The chain Id of currency.")

    __properties: ClassVar[List[str]] = ["currency", "amount", "chain"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositAddressV3Req]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetDepositAddressV3Req]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "chain": obj.get("chain")
        })
        return _obj


class GetDepositAddressV3ReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetDepositAddressV3ReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_amount(self, value: str) -> GetDepositAddressV3ReqBuilder:
        """
        Deposit amount. This parameter is only used when applying for invoices on the Lightning Network. This parameter is invalid if it is not passed through the Lightning Network.
        """
        self.obj['amount'] = value
        return self

    def set_chain(self, value: str) -> GetDepositAddressV3ReqBuilder:
        """
        The chain Id of currency.
        """
        self.obj['chain'] = value
        return self

    def build(self) -> GetDepositAddressV3Req:
        return GetDepositAddressV3Req(**self.obj)
