# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetBasicFeeReq(BaseModel):
    """
    GetBasicFeeReq

    Attributes:
        currency_type (CurrencyTypeEnum): Currency type: 0-crypto currency, 1-fiat currency. default is 0-crypto currency 
    """

    class CurrencyTypeEnum(Enum):
        """
        Attributes:
            T_0: crypto currency
            T_1: fiat currency
        """
        T_0 = 0
        T_1 = 1

    currency_type: Optional[CurrencyTypeEnum] = Field(
        default=CurrencyTypeEnum.T_0,
        description=
        "Currency type: 0-crypto currency, 1-fiat currency. default is 0-crypto currency ",
        alias="currencyType")

    __properties: ClassVar[List[str]] = ["currencyType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetBasicFeeReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetBasicFeeReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currencyType":
            obj.get("currencyType") if obj.get("currencyType") is not None else
            GetBasicFeeReq.CurrencyTypeEnum.T_0
        })
        return _obj


class GetBasicFeeReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency_type(
            self,
            value: GetBasicFeeReq.CurrencyTypeEnum) -> GetBasicFeeReqBuilder:
        """
        Currency type: 0-crypto currency, 1-fiat currency. default is 0-crypto currency 
        """
        self.obj['currencyType'] = value
        return self

    def build(self) -> GetBasicFeeReq:
        return GetBasicFeeReq(**self.obj)
