# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetFuturesActualFeeResp(BaseModel, Response):
    """
    GetFuturesActualFeeResp

    Attributes:
        symbol (str): The unique identity of the trading pair and will not change even if the trading pair is renamed
        taker_fee_rate (str): Actual taker fee rate of the trading pair
        maker_fee_rate (str): Actual maker fee rate of the trading pair
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "The unique identity of the trading pair and will not change even if the trading pair is renamed"
    )
    taker_fee_rate: Optional[str] = Field(
        default=None,
        description="Actual taker fee rate of the trading pair",
        alias="takerFeeRate")
    maker_fee_rate: Optional[str] = Field(
        default=None,
        description="Actual maker fee rate of the trading pair",
        alias="makerFeeRate")

    __properties: ClassVar[List[str]] = [
        "symbol", "takerFeeRate", "makerFeeRate"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetFuturesActualFeeResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetFuturesActualFeeResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "takerFeeRate": obj.get("takerFeeRate"),
            "makerFeeRate": obj.get("makerFeeRate")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
