# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddSubAccountReq(BaseModel):
    """
    AddSubAccountReq

    Attributes:
        password (str): Password(7-24 characters, must contain letters and numbers, cannot only contain numbers or include special characters)
        remarks (str): Remarks(1~24 characters)
        sub_name (str): Sub-account name(must contain 7-32 characters, at least one number and one letter. Cannot contain any spaces.)
        access (AccessEnum): Permission (types include Spot, Futures, Margin permissions, which can be used alone or in combination).
    """

    class AccessEnum(Enum):
        """
        Attributes:
            SPOT: Spot Account
            FUTURES: Futures Account
            MARGIN: Margin Account
        """
        SPOT = 'Spot'
        FUTURES = 'Futures'
        MARGIN = 'Margin'

    password: Optional[str] = Field(
        default=None,
        description=
        "Password(7-24 characters, must contain letters and numbers, cannot only contain numbers or include special characters)"
    )
    remarks: Optional[str] = Field(default=None,
                                   description="Remarks(1~24 characters)")
    sub_name: Optional[str] = Field(
        default=None,
        description=
        "Sub-account name(must contain 7-32 characters, at least one number and one letter. Cannot contain any spaces.)",
        alias="subName")
    access: Optional[AccessEnum] = Field(
        default=None,
        description=
        "Permission (types include Spot, Futures, Margin permissions, which can be used alone or in combination)."
    )

    __properties: ClassVar[List[str]] = [
        "password", "remarks", "subName", "access"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddSubAccountReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AddSubAccountReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "password": obj.get("password"),
            "remarks": obj.get("remarks"),
            "subName": obj.get("subName"),
            "access": obj.get("access")
        })
        return _obj


class AddSubAccountReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_password(self, value: str) -> AddSubAccountReqBuilder:
        """
        Password(7-24 characters, must contain letters and numbers, cannot only contain numbers or include special characters)
        """
        self.obj['password'] = value
        return self

    def set_remarks(self, value: str) -> AddSubAccountReqBuilder:
        """
        Remarks(1~24 characters)
        """
        self.obj['remarks'] = value
        return self

    def set_sub_name(self, value: str) -> AddSubAccountReqBuilder:
        """
        Sub-account name(must contain 7-32 characters, at least one number and one letter. Cannot contain any spaces.)
        """
        self.obj['subName'] = value
        return self

    def set_access(
            self,
            value: AddSubAccountReq.AccessEnum) -> AddSubAccountReqBuilder:
        """
        Permission (types include Spot, Futures, Margin permissions, which can be used alone or in combination).
        """
        self.obj['access'] = value
        return self

    def build(self) -> AddSubAccountReq:
        return AddSubAccountReq(**self.obj)
