# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotSubAccountDetailReq(BaseModel):
    """
    GetSpotSubAccountDetailReq

    Attributes:
        sub_user_id (str): the userID of a sub-account.
        include_base_amount (bool): false: do not display the currency which asset is 0, true: display all currency
    """

    sub_user_id: Optional[str] = Field(
        default=None,
        path_variable="True",
        description="the userID of a sub-account.",
        alias="subUserId")
    include_base_amount: Optional[bool] = Field(
        default=None,
        description=
        "false: do not display the currency which asset is 0, true: display all currency",
        alias="includeBaseAmount")

    __properties: ClassVar[List[str]] = ["subUserId", "includeBaseAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotSubAccountDetailReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetSpotSubAccountDetailReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subUserId":
            obj.get("subUserId"),
            "includeBaseAmount":
            obj.get("includeBaseAmount")
        })
        return _obj


class GetSpotSubAccountDetailReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_sub_user_id(self, value: str) -> GetSpotSubAccountDetailReqBuilder:
        """
        the userID of a sub-account.
        """
        self.obj['subUserId'] = value
        return self

    def set_include_base_amount(
            self, value: bool) -> GetSpotSubAccountDetailReqBuilder:
        """
        false: do not display the currency which asset is 0, true: display all currency
        """
        self.obj['includeBaseAmount'] = value
        return self

    def build(self) -> GetSpotSubAccountDetailReq:
        return GetSpotSubAccountDetailReq(**self.obj)
