# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotSubAccountsSummaryV2Items(BaseModel):
    """
    GetSpotSubAccountsSummaryV2Items

    Attributes:
        user_id (str): Sub-account User Id
        uid (int): Sub-account UID
        sub_name (str): Sub-account name
        status (StatusEnum): Sub-account; 2:Enable, 3:Frozen
        type (TypeEnum): Sub-account type
        access (str): Sub-account Permission
        created_at (int): Time of the event
        remarks (str): Remarks
        trade_types (list[str]): Subaccount Permissions
        opened_trade_types (list[str]): Subaccount active permissions,If do not have the corresponding permissions, need to log in to the sub-account and go to the corresponding web page to activate
        hosted_status (str): 
    """

    class StatusEnum(Enum):
        """
        Attributes:
            T_2: Enable
            T_3: Frozen
        """
        T_2 = 2
        T_3 = 3

    class TypeEnum(Enum):
        """
        Attributes:
            NORMAL: Normal subaccount
            ROBOT: Robot subaccount
            NOVICE: New financial sub-account
            HOSTED: Asset management subaccount
        """
        NORMAL = 0
        ROBOT = 1
        NOVICE = 2
        HOSTED = 5

    user_id: Optional[str] = Field(default=None,
                                   description="Sub-account User Id",
                                   alias="userId")
    uid: Optional[int] = Field(default=None, description="Sub-account UID")
    sub_name: Optional[str] = Field(default=None,
                                    description="Sub-account name",
                                    alias="subName")
    status: Optional[StatusEnum] = Field(
        default=None, description="Sub-account; 2:Enable, 3:Frozen")
    type: Optional[TypeEnum] = Field(default=None,
                                     description="Sub-account type")
    access: Optional[str] = Field(default=None,
                                  description="Sub-account Permission")
    created_at: Optional[int] = Field(default=None,
                                      description="Time of the event",
                                      alias="createdAt")
    remarks: Optional[str] = Field(default=None, description="Remarks")
    trade_types: Optional[List[str]] = Field(
        default=None, description="Subaccount Permissions", alias="tradeTypes")
    opened_trade_types: Optional[List[str]] = Field(
        default=None,
        description=
        "Subaccount active permissions,If do not have the corresponding permissions, need to log in to the sub-account and go to the corresponding web page to activate",
        alias="openedTradeTypes")
    hosted_status: Optional[str] = Field(default=None, alias="hostedStatus")

    __properties: ClassVar[List[str]] = [
        "userId", "uid", "subName", "status", "type", "access", "createdAt",
        "remarks", "tradeTypes", "openedTradeTypes", "hostedStatus"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetSpotSubAccountsSummaryV2Items]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetSpotSubAccountsSummaryV2Items]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId":
            obj.get("userId"),
            "uid":
            obj.get("uid"),
            "subName":
            obj.get("subName"),
            "status":
            obj.get("status"),
            "type":
            obj.get("type"),
            "access":
            obj.get("access"),
            "createdAt":
            obj.get("createdAt"),
            "remarks":
            obj.get("remarks"),
            "tradeTypes":
            obj.get("tradeTypes"),
            "openedTradeTypes":
            obj.get("openedTradeTypes"),
            "hostedStatus":
            obj.get("hostedStatus")
        })
        return _obj
