# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class FlexTransferReq(BaseModel):
    """
    FlexTransferReq

    Attributes:
        client_oid (str): Unique order id created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits
        currency (str): currency
        amount (str): Transfer amount, the amount is a positive integer multiple of the currency precision.
        from_user_id (str): Transfer out UserId， This is required when transferring sub-account to master-account. It is optional for internal transfers.
        from_account_type (FromAccountTypeEnum): Account type：MAIN、TRADE、CONTRACT、MARGIN、ISOLATED、MARGIN_V2、ISOLATED_V2
        from_account_tag (str): Symbol, required when the account type is ISOLATED or ISOLATED_V2, for example: BTC-USDT
        type (TypeEnum): Transfer type：INTERNAL(Transfer within account)、PARENT_TO_SUB(Transfer from master-account to sub-account)，SUB_TO_PARENT(Transfer from sub-account to master-account)
        to_user_id (str): Transfer in UserId， This is required when transferring master-account to sub-account. It is optional for internal transfers.
        to_account_type (ToAccountTypeEnum): Account type：MAIN、TRADE、CONTRACT、MARGIN、ISOLATED、MARGIN_V2、ISOLATED_V2
        to_account_tag (str): Symbol, required when the account type is ISOLATED or ISOLATED_V2, for example: BTC-USDT
    """

    class FromAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
            CONTRACT: Futures account
            MARGIN: Cross margin account
            ISOLATED: Isolated margin account
            MARGIN_V2: Cross margin account
            ISOLATED_V2: Isolated margin account
            OPTION: Option account
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        CONTRACT = 'CONTRACT'
        MARGIN = 'MARGIN'
        ISOLATED = 'ISOLATED'
        MARGIN_V2 = 'MARGIN_V2'
        ISOLATED_V2 = 'ISOLATED_V2'
        OPTION = 'OPTION'

    class TypeEnum(Enum):
        """
        Attributes:
            INTERNAL: 
            PARENT_TO_SUB: 
            SUB_TO_PARENT: 
        """
        INTERNAL = 'INTERNAL'
        PARENT_TO_SUB = 'PARENT_TO_SUB'
        SUB_TO_PARENT = 'SUB_TO_PARENT'

    class ToAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
            CONTRACT: Futures account
            MARGIN: Cross margin account
            ISOLATED: Isolated margin account
            MARGIN_V2: Cross margin account
            ISOLATED_V2: Isolated margin account
            OPTION: Option account
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        CONTRACT = 'CONTRACT'
        MARGIN = 'MARGIN'
        ISOLATED = 'ISOLATED'
        MARGIN_V2 = 'MARGIN_V2'
        ISOLATED_V2 = 'ISOLATED_V2'
        OPTION = 'OPTION'

    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Unique order id created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits",
        alias="clientOid")
    currency: Optional[str] = Field(default=None, description="currency")
    amount: Optional[str] = Field(
        default=None,
        description=
        "Transfer amount, the amount is a positive integer multiple of the currency precision."
    )
    from_user_id: Optional[str] = Field(
        default=None,
        description=
        "Transfer out UserId， This is required when transferring sub-account to master-account. It is optional for internal transfers.",
        alias="fromUserId")
    from_account_type: Optional[FromAccountTypeEnum] = Field(
        default=None,
        description=
        "Account type：MAIN、TRADE、CONTRACT、MARGIN、ISOLATED、MARGIN_V2、ISOLATED_V2",
        alias="fromAccountType")
    from_account_tag: Optional[str] = Field(
        default=None,
        description=
        "Symbol, required when the account type is ISOLATED or ISOLATED_V2, for example: BTC-USDT",
        alias="fromAccountTag")
    type: Optional[TypeEnum] = Field(
        default=None,
        description=
        "Transfer type：INTERNAL(Transfer within account)、PARENT_TO_SUB(Transfer from master-account to sub-account)，SUB_TO_PARENT(Transfer from sub-account to master-account)"
    )
    to_user_id: Optional[str] = Field(
        default=None,
        description=
        "Transfer in UserId， This is required when transferring master-account to sub-account. It is optional for internal transfers.",
        alias="toUserId")
    to_account_type: Optional[ToAccountTypeEnum] = Field(
        default=None,
        description=
        "Account type：MAIN、TRADE、CONTRACT、MARGIN、ISOLATED、MARGIN_V2、ISOLATED_V2",
        alias="toAccountType")
    to_account_tag: Optional[str] = Field(
        default=None,
        description=
        "Symbol, required when the account type is ISOLATED or ISOLATED_V2, for example: BTC-USDT",
        alias="toAccountTag")

    __properties: ClassVar[List[str]] = [
        "clientOid", "currency", "amount", "fromUserId", "fromAccountType",
        "fromAccountTag", "type", "toUserId", "toAccountType", "toAccountTag"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[FlexTransferReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[FlexTransferReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientOid": obj.get("clientOid"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "fromUserId": obj.get("fromUserId"),
            "fromAccountType": obj.get("fromAccountType"),
            "fromAccountTag": obj.get("fromAccountTag"),
            "type": obj.get("type"),
            "toUserId": obj.get("toUserId"),
            "toAccountType": obj.get("toAccountType"),
            "toAccountTag": obj.get("toAccountTag")
        })
        return _obj


class FlexTransferReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_client_oid(self, value: str) -> FlexTransferReqBuilder:
        """
        Unique order id created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits
        """
        self.obj['clientOid'] = value
        return self

    def set_currency(self, value: str) -> FlexTransferReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_amount(self, value: str) -> FlexTransferReqBuilder:
        """
        Transfer amount, the amount is a positive integer multiple of the currency precision.
        """
        self.obj['amount'] = value
        return self

    def set_from_user_id(self, value: str) -> FlexTransferReqBuilder:
        """
        Transfer out UserId， This is required when transferring sub-account to master-account. It is optional for internal transfers.
        """
        self.obj['fromUserId'] = value
        return self

    def set_from_account_type(
            self, value: FlexTransferReq.FromAccountTypeEnum
    ) -> FlexTransferReqBuilder:
        """
        Account type：MAIN、TRADE、CONTRACT、MARGIN、ISOLATED、MARGIN_V2、ISOLATED_V2
        """
        self.obj['fromAccountType'] = value
        return self

    def set_from_account_tag(self, value: str) -> FlexTransferReqBuilder:
        """
        Symbol, required when the account type is ISOLATED or ISOLATED_V2, for example: BTC-USDT
        """
        self.obj['fromAccountTag'] = value
        return self

    def set_type(self,
                 value: FlexTransferReq.TypeEnum) -> FlexTransferReqBuilder:
        """
        Transfer type：INTERNAL(Transfer within account)、PARENT_TO_SUB(Transfer from master-account to sub-account)，SUB_TO_PARENT(Transfer from sub-account to master-account)
        """
        self.obj['type'] = value
        return self

    def set_to_user_id(self, value: str) -> FlexTransferReqBuilder:
        """
        Transfer in UserId， This is required when transferring master-account to sub-account. It is optional for internal transfers.
        """
        self.obj['toUserId'] = value
        return self

    def set_to_account_type(
            self, value: FlexTransferReq.ToAccountTypeEnum
    ) -> FlexTransferReqBuilder:
        """
        Account type：MAIN、TRADE、CONTRACT、MARGIN、ISOLATED、MARGIN_V2、ISOLATED_V2
        """
        self.obj['toAccountType'] = value
        return self

    def set_to_account_tag(self, value: str) -> FlexTransferReqBuilder:
        """
        Symbol, required when the account type is ISOLATED or ISOLATED_V2, for example: BTC-USDT
        """
        self.obj['toAccountTag'] = value
        return self

    def build(self) -> FlexTransferReq:
        return FlexTransferReq(**self.obj)
