# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetFuturesAccountTransferOutLedgerReq(BaseModel):
    """
    GetFuturesAccountTransferOutLedgerReq

    Attributes:
        currency (str): currency
        type (TypeEnum): Status PROCESSING, SUCCESS, FAILURE
        tag (list[str]): Status List PROCESSING, SUCCESS, FAILURE
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current request page, The default currentPage is 1
        page_size (int): pageSize, The default pageSize is 50
    """

    class TypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
            MARGIN: 
            ISOLATED: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        MARGIN = 'MARGIN'
        ISOLATED = 'ISOLATED'

    currency: Optional[str] = Field(default=None, description="currency")
    type: Optional[TypeEnum] = Field(
        default=None, description="Status PROCESSING, SUCCESS, FAILURE")
    tag: Optional[List[str]] = Field(
        default=None, description="Status List PROCESSING, SUCCESS, FAILURE")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(
        default=1,
        description="Current request page, The default currentPage is 1",
        alias="currentPage")
    page_size: Optional[int] = Field(
        default=50,
        description="pageSize, The default pageSize is 50",
        alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "currency", "type", "tag", "startAt", "endAt", "currentPage",
        "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls,
            json_str: str) -> Optional[GetFuturesAccountTransferOutLedgerReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetFuturesAccountTransferOutLedgerReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "type":
            obj.get("type"),
            "tag":
            obj.get("tag"),
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 50
        })
        return _obj


class GetFuturesAccountTransferOutLedgerReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(
            self, value: str) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_type(
        self, value: GetFuturesAccountTransferOutLedgerReq.TypeEnum
    ) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        Status PROCESSING, SUCCESS, FAILURE
        """
        self.obj['type'] = value
        return self

    def set_tag(
            self,
            value: list[str]) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        Status List PROCESSING, SUCCESS, FAILURE
        """
        self.obj['tag'] = value
        return self

    def set_start_at(
            self, value: int) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self,
                   value: int) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(
            self, value: int) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        Current request page, The default currentPage is 1
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(
            self, value: int) -> GetFuturesAccountTransferOutLedgerReqBuilder:
        """
        pageSize, The default pageSize is 50
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetFuturesAccountTransferOutLedgerReq:
        return GetFuturesAccountTransferOutLedgerReq(**self.obj)
