# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetDepositDetailResp(BaseModel, Response):
    """
    GetDepositDetailResp

    Attributes:
        chain (str): chain id of currency
        hash (str): Hash
        wallet_tx_id (str): Wallet Transaction ID
        uid (int): UID
        updated_at (int): Update Time (milliseconds)
        amount (str): Amount
        memo (str): Memo
        fee (str): Fee
        address (str): Address
        remark (str): Remark
        is_inner (bool): Is Internal (true or false)
        currency (str): Currency
        status (StatusEnum): Status (PROCESSING, SUCCESS, FAILURE)
        created_at (int): Creation Time (milliseconds)
    """

    class StatusEnum(Enum):
        """
        Attributes:
            SUCCESS: 
            FAILURE: 
            PROCESSING: 
        """
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'
        PROCESSING = 'PROCESSING'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    chain: Optional[str] = Field(default=None,
                                 description="chain id of currency")
    hash: Optional[str] = Field(default=None, description="Hash")
    wallet_tx_id: Optional[str] = Field(default=None,
                                        description="Wallet Transaction ID",
                                        alias="walletTxId")
    uid: Optional[int] = Field(default=None, description="UID")
    updated_at: Optional[int] = Field(default=None,
                                      description="Update Time (milliseconds)",
                                      alias="updatedAt")
    amount: Optional[str] = Field(default=None, description="Amount")
    memo: Optional[str] = Field(default=None, description="Memo")
    fee: Optional[str] = Field(default=None, description="Fee")
    address: Optional[str] = Field(default=None, description="Address")
    remark: Optional[str] = Field(default=None, description="Remark")
    is_inner: Optional[bool] = Field(default=None,
                                     description="Is Internal (true or false)",
                                     alias="isInner")
    currency: Optional[str] = Field(default=None, description="Currency")
    status: Optional[StatusEnum] = Field(
        default=None, description="Status (PROCESSING, SUCCESS, FAILURE)")
    created_at: Optional[int] = Field(
        default=None,
        description="Creation Time (milliseconds)",
        alias="createdAt")

    __properties: ClassVar[List[str]] = [
        "chain", "hash", "walletTxId", "uid", "updatedAt", "amount", "memo",
        "fee", "address", "remark", "isInner", "currency", "status",
        "createdAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositDetailResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetDepositDetailResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chain": obj.get("chain"),
            "hash": obj.get("hash"),
            "walletTxId": obj.get("walletTxId"),
            "uid": obj.get("uid"),
            "updatedAt": obj.get("updatedAt"),
            "amount": obj.get("amount"),
            "memo": obj.get("memo"),
            "fee": obj.get("fee"),
            "address": obj.get("address"),
            "remark": obj.get("remark"),
            "isInner": obj.get("isInner"),
            "currency": obj.get("currency"),
            "status": obj.get("status"),
            "createdAt": obj.get("createdAt")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
