# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetSubAccountReq(BaseModel):
    """
    GetSubAccountReq

    Attributes:
        uid (str): Sub-account UID
        current_page (int): Current page, default is 1
        page_size (int): The number returned per page, the default is 20, the maximum is 100
    """

    uid: Optional[str] = Field(default=None, description="Sub-account UID")
    current_page: Optional[int] = Field(
        default=1,
        description="Current page, default is 1",
        alias="currentPage")
    page_size: Optional[Annotated[int, Field(
        le=100, strict=True, ge=1
    )]] = Field(
        default=20,
        description=
        "The number returned per page, the default is 20, the maximum is 100",
        alias="pageSize")

    __properties: ClassVar[List[str]] = ["uid", "currentPage", "pageSize"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSubAccountReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetSubAccountReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid":
            obj.get("uid"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 20
        })
        return _obj


class GetSubAccountReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_uid(self, value: str) -> GetSubAccountReqBuilder:
        """
        Sub-account UID
        """
        self.obj['uid'] = value
        return self

    def set_current_page(self, value: int) -> GetSubAccountReqBuilder:
        """
        Current page, default is 1
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetSubAccountReqBuilder:
        """
        The number returned per page, the default is 20, the maximum is 100
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetSubAccountReq:
        return GetSubAccountReq(**self.obj)
