# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetTransferHistoryResp(BaseModel, Response):
    """
    GetTransferHistoryResp

    Attributes:
        order_id (str): Transfer Order ID
        currency (str): Currency
        amount (str): Transfer Amount
        from_uid (int): UID of the user transferring out
        from_account_type (FromAccountTypeEnum): From Account Type:Account Type: MAIN, TRADE, CONTRACT, MARGIN, ISOLATED
        from_account_tag (str): Trading pair, required if the account type is ISOLATED, e.g., BTC-USDT
        to_uid (int): UID of the user transferring in
        to_account_type (ToAccountTypeEnum): Account Type:Account Type: MAIN, TRADE, CONTRACT, MARGIN, ISOLATED
        to_account_tag (str): To Trading pair, required if the account type is ISOLATED, e.g., BTC-USDT
        status (StatusEnum): Status: PROCESSING (processing), SUCCESS (successful), FAILURE (failed)
        reason (str): Failure Reason
        created_at (int): Creation Time (Unix timestamp in milliseconds)
    """

    class FromAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
            CONTRACT: 
            MARGIN: 
            ISOLATED: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        CONTRACT = 'CONTRACT'
        MARGIN = 'MARGIN'
        ISOLATED = 'ISOLATED'

    class ToAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
            CONTRACT: 
            MARGIN: 
            ISOLATED: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'
        CONTRACT = 'CONTRACT'
        MARGIN = 'MARGIN'
        ISOLATED = 'ISOLATED'

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    order_id: Optional[str] = Field(default=None,
                                    description="Transfer Order ID",
                                    alias="orderId")
    currency: Optional[str] = Field(default=None, description="Currency")
    amount: Optional[str] = Field(default=None, description="Transfer Amount")
    from_uid: Optional[int] = Field(
        default=None,
        description="UID of the user transferring out",
        alias="fromUid")
    from_account_type: Optional[FromAccountTypeEnum] = Field(
        default=None,
        description=
        "From Account Type:Account Type: MAIN, TRADE, CONTRACT, MARGIN, ISOLATED",
        alias="fromAccountType")
    from_account_tag: Optional[str] = Field(
        default=None,
        description=
        "Trading pair, required if the account type is ISOLATED, e.g., BTC-USDT",
        alias="fromAccountTag")
    to_uid: Optional[int] = Field(
        default=None,
        description="UID of the user transferring in",
        alias="toUid")
    to_account_type: Optional[ToAccountTypeEnum] = Field(
        default=None,
        description=
        "Account Type:Account Type: MAIN, TRADE, CONTRACT, MARGIN, ISOLATED",
        alias="toAccountType")
    to_account_tag: Optional[str] = Field(
        default=None,
        description=
        "To Trading pair, required if the account type is ISOLATED, e.g., BTC-USDT",
        alias="toAccountTag")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Status: PROCESSING (processing), SUCCESS (successful), FAILURE (failed)"
    )
    reason: Optional[str] = Field(default=None, description="Failure Reason")
    created_at: Optional[int] = Field(
        default=None,
        description="Creation Time (Unix timestamp in milliseconds)",
        alias="createdAt")

    __properties: ClassVar[List[str]] = [
        "orderId", "currency", "amount", "fromUid", "fromAccountType",
        "fromAccountTag", "toUid", "toAccountType", "toAccountTag", "status",
        "reason", "createdAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTransferHistoryResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetTransferHistoryResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId": obj.get("orderId"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "fromUid": obj.get("fromUid"),
            "fromAccountType": obj.get("fromAccountType"),
            "fromAccountTag": obj.get("fromAccountTag"),
            "toUid": obj.get("toUid"),
            "toAccountType": obj.get("toAccountType"),
            "toAccountTag": obj.get("toAccountTag"),
            "status": obj.get("status"),
            "reason": obj.get("reason"),
            "createdAt": obj.get("createdAt")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
