# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class ModifySubAccountApiReq(BaseModel):
    """
    ModifySubAccountApiReq

    Attributes:
        uid (str): Subaccount UID
        ip_whitelist (list[str]): IP whitelist list, supports up to 20 IPs
        permissions (list[PermissionsEnum]): [Permissions](https://www.kucoin.com/docs-new/doc-338144) group list(Only General、Spot、Futures permissions can be set, such as \"General, Trade\". ) 
        label (str): apikey remarks (length 4~32) 
        api_key (str): Subaccount apiKey
    """

    class PermissionsEnum(Enum):
        """
        Attributes:
            GENERAL: 
            SPOT: 
            FUTURES: 
        """
        GENERAL = 'general'
        SPOT = 'spot'
        FUTURES = 'futures'

    uid: Optional[str] = Field(default=None, description="Subaccount UID")
    ip_whitelist: Optional[List[str]] = Field(
        default=None,
        description="IP whitelist list, supports up to 20 IPs",
        alias="ipWhitelist")
    permissions: Optional[List[PermissionsEnum]] = Field(
        default=None,
        description=
        "[Permissions](https://www.kucoin.com/docs-new/doc-338144) group list(Only General、Spot、Futures permissions can be set, such as \"General, Trade\". ) "
    )
    label: Optional[str] = Field(default=None,
                                 description="apikey remarks (length 4~32) ")
    api_key: Optional[str] = Field(default=None,
                                   description="Subaccount apiKey",
                                   alias="apiKey")

    __properties: ClassVar[List[str]] = [
        "uid", "ipWhitelist", "permissions", "label", "apiKey"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ModifySubAccountApiReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[ModifySubAccountApiReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "ipWhitelist": obj.get("ipWhitelist"),
            "permissions": obj.get("permissions"),
            "label": obj.get("label"),
            "apiKey": obj.get("apiKey")
        })
        return _obj


class ModifySubAccountApiReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_uid(self, value: str) -> ModifySubAccountApiReqBuilder:
        """
        Subaccount UID
        """
        self.obj['uid'] = value
        return self

    def set_ip_whitelist(self,
                         value: list[str]) -> ModifySubAccountApiReqBuilder:
        """
        IP whitelist list, supports up to 20 IPs
        """
        self.obj['ipWhitelist'] = value
        return self

    def set_permissions(
        self, value: list[ModifySubAccountApiReq.PermissionsEnum]
    ) -> ModifySubAccountApiReqBuilder:
        """
        [Permissions](https://www.kucoin.com/docs-new/doc-338144) group list(Only General、Spot、Futures permissions can be set, such as \"General, Trade\". ) 
        """
        self.obj['permissions'] = value
        return self

    def set_label(self, value: str) -> ModifySubAccountApiReqBuilder:
        """
        apikey remarks (length 4~32) 
        """
        self.obj['label'] = value
        return self

    def set_api_key(self, value: str) -> ModifySubAccountApiReqBuilder:
        """
        Subaccount apiKey
        """
        self.obj['apiKey'] = value
        return self

    def build(self) -> ModifySubAccountApiReq:
        return ModifySubAccountApiReq(**self.obj)
