# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_add_isolated_margin_req import AddIsolatedMarginReq
from .model_add_isolated_margin_resp import AddIsolatedMarginResp
from .model_add_order_req import AddOrderReq
from .model_add_order_resp import AddOrderResp
from .model_add_order_test_req import AddOrderTestReq
from .model_add_order_test_resp import AddOrderTestResp
from .model_add_tpsl_order_req import AddTpslOrderReq
from .model_add_tpsl_order_resp import AddTpslOrderResp
from .model_cancel_order_by_client_oid_req import CancelOrderByClientOidReq
from .model_cancel_order_by_client_oid_resp import CancelOrderByClientOidResp
from .model_cancel_order_by_id_req import CancelOrderByIdReq
from .model_cancel_order_by_id_resp import CancelOrderByIdResp
from .model_get_max_open_size_req import GetMaxOpenSizeReq
from .model_get_max_open_size_resp import GetMaxOpenSizeResp
from .model_get_max_withdraw_margin_req import GetMaxWithdrawMarginReq
from .model_get_max_withdraw_margin_resp import GetMaxWithdrawMarginResp
from .model_modify_auto_deposit_status_req import ModifyAutoDepositStatusReq
from .model_modify_auto_deposit_status_resp import ModifyAutoDepositStatusResp
from .model_modify_isolated_margin_risk_limt_req import ModifyIsolatedMarginRiskLimtReq
from .model_modify_isolated_margin_risk_limt_resp import ModifyIsolatedMarginRiskLimtResp
from .model_remove_isolated_margin_req import RemoveIsolatedMarginReq
from .model_remove_isolated_margin_resp import RemoveIsolatedMarginResp


class FuturesAPI(ABC):

    @abstractmethod
    def add_order(self, req: AddOrderReq, **kwargs: Any) -> AddOrderResp:
        """
        summary: Add Order
        description: Place order to the futures trading system, you can place two major types of orders: limit and market. Orders can only be placed if your account has sufficient funds. Once an order is placed, your funds will be put on hold for the duration of the order. The amount of funds on hold depends on the order type and parameters specified.
        documentation: https://www.kucoin.com/docs-new/api-3470363
        +---------------------+------------------+
        | Extra API Info      | Value            |
        +---------------------+------------------+
        | API-DOMAIN          | FUTURES          |
        | API-CHANNEL         | PRIVATE          |
        | API-PERMISSION      | LEADTRADEFUTURES |
        | API-RATE-LIMIT-POOL | COPYTRADING      |
        | API-RATE-LIMIT      | 2                |
        +---------------------+------------------+
        """
        pass

    @abstractmethod
    def add_order_test(self, req: AddOrderTestReq,
                       **kwargs: Any) -> AddOrderTestResp:
        """
        summary: Add Order Test
        description: Place order to the futures trading system just for validation
        documentation: https://www.kucoin.com/docs-new/api-3470618
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 2           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def add_tpsl_order(self, req: AddTpslOrderReq,
                       **kwargs: Any) -> AddTpslOrderResp:
        """
        summary: Add Take Profit And Stop Loss Order
        description: Place take profit and stop loss order supports both take-profit and stop-loss functions, and other functions are exactly the same as the place order interface.
        documentation: https://www.kucoin.com/docs-new/api-3470619
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 2           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def cancel_order_by_id(self, req: CancelOrderByIdReq,
                           **kwargs: Any) -> CancelOrderByIdResp:
        """
        summary: Cancel Order By OrderId
        description: Cancel order by system generated orderId.
        documentation: https://www.kucoin.com/docs-new/api-3470620
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 1           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def cancel_order_by_client_oid(
            self, req: CancelOrderByClientOidReq,
            **kwargs: Any) -> CancelOrderByClientOidResp:
        """
        summary: Cancel Order By ClientOid
        description: Cancel order by client defined orderId.
        documentation: https://www.kucoin.com/docs-new/api-3470621
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 1           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def get_max_open_size(self, req: GetMaxOpenSizeReq,
                          **kwargs: Any) -> GetMaxOpenSizeResp:
        """
        summary: Get Max Open Size
        description: Get Maximum Open Position Size.
        documentation: https://www.kucoin.com/docs-new/api-3470612
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 2           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def get_max_withdraw_margin(self, req: GetMaxWithdrawMarginReq,
                                **kwargs: Any) -> GetMaxWithdrawMarginResp:
        """
        summary: Get Max Withdraw Margin
        description: This interface can query the maximum amount of margin that the current position supports withdrawal.
        documentation: https://www.kucoin.com/docs-new/api-3470616
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 10          |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def add_isolated_margin(self, req: AddIsolatedMarginReq,
                            **kwargs: Any) -> AddIsolatedMarginResp:
        """
        summary: Add Isolated Margin
        description: Add Isolated Margin Manually.
        documentation: https://www.kucoin.com/docs-new/api-3470614
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 4           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def remove_isolated_margin(self, req: RemoveIsolatedMarginReq,
                               **kwargs: Any) -> RemoveIsolatedMarginResp:
        """
        summary: Remove Isolated Margin
        description: Remove Isolated Margin Manually.
        documentation: https://www.kucoin.com/docs-new/api-3470615
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 10          |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def modify_isolated_margin_risk_limt(
            self, req: ModifyIsolatedMarginRiskLimtReq,
            **kwargs: Any) -> ModifyIsolatedMarginRiskLimtResp:
        """
        summary: Modify Isolated Margin Risk Limit
        description: This interface can be used to obtain information about risk limit level of a specific contract(Only valid for isolated Margin).
        documentation: https://www.kucoin.com/docs-new/api-3470613
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 4           |
        +---------------------+-------------+
        """
        pass

    @abstractmethod
    def modify_auto_deposit_status(
            self, req: ModifyAutoDepositStatusReq,
            **kwargs: Any) -> ModifyAutoDepositStatusResp:
        """
        summary: Modify Isolated Margin Auto-Deposit Status
        description: This endpoint is only applicable to isolated margin and is no longer recommended. It is recommended to use cross margin instead.
        documentation: https://www.kucoin.com/docs-new/api-3470617
        +---------------------+-------------+
        | Extra API Info      | Value       |
        +---------------------+-------------+
        | API-DOMAIN          | FUTURES     |
        | API-CHANNEL         | PRIVATE     |
        | API-PERMISSION      | FUTURES     |
        | API-RATE-LIMIT-POOL | COPYTRADING |
        | API-RATE-LIMIT      | 4           |
        +---------------------+-------------+
        """
        pass


class FuturesAPIImpl(FuturesAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def add_order(self, req: AddOrderReq, **kwargs: Any) -> AddOrderResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/copy-trade/futures/orders", req,
                                   AddOrderResp(), False, **kwargs)

    def add_order_test(self, req: AddOrderTestReq,
                       **kwargs: Any) -> AddOrderTestResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/copy-trade/futures/orders/test",
                                   req, AddOrderTestResp(), False, **kwargs)

    def add_tpsl_order(self, req: AddTpslOrderReq,
                       **kwargs: Any) -> AddTpslOrderResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/copy-trade/futures/st-orders", req,
                                   AddTpslOrderResp(), False, **kwargs)

    def cancel_order_by_id(self, req: CancelOrderByIdReq,
                           **kwargs: Any) -> CancelOrderByIdResp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v1/copy-trade/futures/orders", req,
                                   CancelOrderByIdResp(), False, **kwargs)

    def cancel_order_by_client_oid(
            self, req: CancelOrderByClientOidReq,
            **kwargs: Any) -> CancelOrderByClientOidResp:
        return self.transport.call(
            "futures", False, "DELETE",
            "/api/v1/copy-trade/futures/orders/client-order", req,
            CancelOrderByClientOidResp(), False, **kwargs)

    def get_max_open_size(self, req: GetMaxOpenSizeReq,
                          **kwargs: Any) -> GetMaxOpenSizeResp:
        return self.transport.call(
            "futures", False, "GET",
            "/api/v1/copy-trade/futures/get-max-open-size", req,
            GetMaxOpenSizeResp(), False, **kwargs)

    def get_max_withdraw_margin(self, req: GetMaxWithdrawMarginReq,
                                **kwargs: Any) -> GetMaxWithdrawMarginResp:
        return self.transport.call(
            "futures", False, "GET",
            "/api/v1/copy-trade/futures/position/margin/max-withdraw-margin",
            req, GetMaxWithdrawMarginResp(), False, **kwargs)

    def add_isolated_margin(self, req: AddIsolatedMarginReq,
                            **kwargs: Any) -> AddIsolatedMarginResp:
        return self.transport.call(
            "futures", False, "POST",
            "/api/v1/copy-trade/futures/position/margin/deposit-margin", req,
            AddIsolatedMarginResp(), False, **kwargs)

    def remove_isolated_margin(self, req: RemoveIsolatedMarginReq,
                               **kwargs: Any) -> RemoveIsolatedMarginResp:
        return self.transport.call(
            "futures", False, "POST",
            "/api/v1/copy-trade/futures/position/margin/withdraw-margin", req,
            RemoveIsolatedMarginResp(), False, **kwargs)

    def modify_isolated_margin_risk_limt(
            self, req: ModifyIsolatedMarginRiskLimtReq,
            **kwargs: Any) -> ModifyIsolatedMarginRiskLimtResp:
        return self.transport.call(
            "futures", False, "POST",
            "/api/v1/copy-trade/futures/position/risk-limit-level/change", req,
            ModifyIsolatedMarginRiskLimtResp(), False, **kwargs)

    def modify_auto_deposit_status(
            self, req: ModifyAutoDepositStatusReq,
            **kwargs: Any) -> ModifyAutoDepositStatusResp:
        return self.transport.call(
            "futures", False, "POST",
            "/api/v1/copy-trade/futures/position/margin/auto-deposit-status",
            req, ModifyAutoDepositStatusResp(), False, **kwargs)
