# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAccountHoldingItems(BaseModel):
    """
    GetAccountHoldingItems

    Attributes:
        order_id (str): Holding ID
        product_id (str): Product ID
        product_category (str): Product category
        product_type (str): Product sub-type
        currency (str): currency
        income_currency (str): Income currency
        return_rate (str): Annualized Rate of Return, for example, 0.035 is equal to 3.5% annualized rate of return
        hold_amount (str): Holding amount
        redeemed_amount (str): Redeemed amount
        redeeming_amount (str): Redeeming amount
        lock_start_time (int): Product earliest interest start time, in milliseconds
        lock_end_time (int): Product maturity time, in milliseconds
        purchase_time (int): Most recent subscription time, in milliseconds
        redeem_period (int): Redemption waiting period (days)
        status (StatusEnum): Status: LOCKED (holding), REDEEMING (redeeming)
        early_redeem_supported (EarlyRedeemSupportedEnum): Whether the fixed product supports early redemption: 0 (no), 1 (yes)
    """

    class StatusEnum(Enum):
        """
        Attributes:
            LOCKED: 
            REDEEMING: 
        """
        LOCKED = 'LOCKED'
        REDEEMING = 'REDEEMING'

    class EarlyRedeemSupportedEnum(Enum):
        """
        Attributes:
            T_0: 
            T_1: 
        """
        T_0 = 0
        T_1 = 1

    order_id: Optional[str] = Field(default=None,
                                    description="Holding ID",
                                    alias="orderId")
    product_id: Optional[str] = Field(default=None,
                                      description="Product ID",
                                      alias="productId")
    product_category: Optional[str] = Field(default=None,
                                            description="Product category",
                                            alias="productCategory")
    product_type: Optional[str] = Field(default=None,
                                        description="Product sub-type",
                                        alias="productType")
    currency: Optional[str] = Field(default=None, description="currency")
    income_currency: Optional[str] = Field(default=None,
                                           description="Income currency",
                                           alias="incomeCurrency")
    return_rate: Optional[str] = Field(
        default=None,
        description=
        "Annualized Rate of Return, for example, 0.035 is equal to 3.5% annualized rate of return",
        alias="returnRate")
    hold_amount: Optional[str] = Field(default=None,
                                       description="Holding amount",
                                       alias="holdAmount")
    redeemed_amount: Optional[str] = Field(default=None,
                                           description="Redeemed amount",
                                           alias="redeemedAmount")
    redeeming_amount: Optional[str] = Field(default=None,
                                            description="Redeeming amount",
                                            alias="redeemingAmount")
    lock_start_time: Optional[int] = Field(
        default=None,
        description="Product earliest interest start time, in milliseconds",
        alias="lockStartTime")
    lock_end_time: Optional[int] = Field(
        default=None,
        description="Product maturity time, in milliseconds",
        alias="lockEndTime")
    purchase_time: Optional[int] = Field(
        default=None,
        description="Most recent subscription time, in milliseconds",
        alias="purchaseTime")
    redeem_period: Optional[int] = Field(
        default=None,
        description="Redemption waiting period (days)",
        alias="redeemPeriod")
    status: Optional[StatusEnum] = Field(
        default=None,
        description="Status: LOCKED (holding), REDEEMING (redeeming)")
    early_redeem_supported: Optional[EarlyRedeemSupportedEnum] = Field(
        default=None,
        description=
        "Whether the fixed product supports early redemption: 0 (no), 1 (yes)",
        alias="earlyRedeemSupported")

    __properties: ClassVar[List[str]] = [
        "orderId", "productId", "productCategory", "productType", "currency",
        "incomeCurrency", "returnRate", "holdAmount", "redeemedAmount",
        "redeemingAmount", "lockStartTime", "lockEndTime", "purchaseTime",
        "redeemPeriod", "status", "earlyRedeemSupported"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAccountHoldingItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAccountHoldingItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId":
            obj.get("orderId"),
            "productId":
            obj.get("productId"),
            "productCategory":
            obj.get("productCategory"),
            "productType":
            obj.get("productType"),
            "currency":
            obj.get("currency"),
            "incomeCurrency":
            obj.get("incomeCurrency"),
            "returnRate":
            obj.get("returnRate"),
            "holdAmount":
            obj.get("holdAmount"),
            "redeemedAmount":
            obj.get("redeemedAmount"),
            "redeemingAmount":
            obj.get("redeemingAmount"),
            "lockStartTime":
            obj.get("lockStartTime"),
            "lockEndTime":
            obj.get("lockEndTime"),
            "purchaseTime":
            obj.get("purchaseTime"),
            "redeemPeriod":
            obj.get("redeemPeriod"),
            "status":
            obj.get("status"),
            "earlyRedeemSupported":
            obj.get("earlyRedeemSupported")
        })
        return _obj
