# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetRedeemPreviewReq(BaseModel):
    """
    GetRedeemPreviewReq

    Attributes:
        order_id (str): Holding ID
        from_account_type (FromAccountTypeEnum): Account type: MAIN (funding account), TRADE (spot trading account). This parameter is valid only when orderId=ETH2
    """

    class FromAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'

    order_id: Optional[str] = Field(default=None,
                                    description="Holding ID",
                                    alias="orderId")
    from_account_type: Optional[FromAccountTypeEnum] = Field(
        default=None,
        description=
        "Account type: MAIN (funding account), TRADE (spot trading account). This parameter is valid only when orderId=ETH2",
        alias="fromAccountType")

    __properties: ClassVar[List[str]] = ["orderId", "fromAccountType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetRedeemPreviewReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetRedeemPreviewReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId": obj.get("orderId"),
            "fromAccountType": obj.get("fromAccountType")
        })
        return _obj


class GetRedeemPreviewReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_order_id(self, value: str) -> GetRedeemPreviewReqBuilder:
        """
        Holding ID
        """
        self.obj['orderId'] = value
        return self

    def set_from_account_type(
        self, value: GetRedeemPreviewReq.FromAccountTypeEnum
    ) -> GetRedeemPreviewReqBuilder:
        """
        Account type: MAIN (funding account), TRADE (spot trading account). This parameter is valid only when orderId=ETH2
        """
        self.obj['fromAccountType'] = value
        return self

    def build(self) -> GetRedeemPreviewReq:
        return GetRedeemPreviewReq(**self.obj)
