# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class RedeemReq(BaseModel):
    """
    RedeemReq

    Attributes:
        order_id (str): Holding ID
        amount (str): Redemption amount
        from_account_type (FromAccountTypeEnum): Account type: MAIN (funding account), TRADE (spot trading account). This parameter is valid only when orderId=ETH2
        confirm_punish_redeem (str): Confirmation field for early redemption penalty: 1 (confirm early redemption, and the current holding will be fully redeemed). This parameter is valid only for fixed-term products
    """

    class FromAccountTypeEnum(Enum):
        """
        Attributes:
            MAIN: 
            TRADE: 
        """
        MAIN = 'MAIN'
        TRADE = 'TRADE'

    order_id: Optional[str] = Field(default=None,
                                    description="Holding ID",
                                    alias="orderId")
    amount: Optional[str] = Field(default=None,
                                  description="Redemption amount")
    from_account_type: Optional[FromAccountTypeEnum] = Field(
        default=None,
        description=
        "Account type: MAIN (funding account), TRADE (spot trading account). This parameter is valid only when orderId=ETH2",
        alias="fromAccountType")
    confirm_punish_redeem: Optional[str] = Field(
        default=None,
        description=
        "Confirmation field for early redemption penalty: 1 (confirm early redemption, and the current holding will be fully redeemed). This parameter is valid only for fixed-term products",
        alias="confirmPunishRedeem")

    __properties: ClassVar[List[str]] = [
        "orderId", "amount", "fromAccountType", "confirmPunishRedeem"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[RedeemReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[RedeemReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId":
            obj.get("orderId"),
            "amount":
            obj.get("amount"),
            "fromAccountType":
            obj.get("fromAccountType"),
            "confirmPunishRedeem":
            obj.get("confirmPunishRedeem")
        })
        return _obj


class RedeemReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_order_id(self, value: str) -> RedeemReqBuilder:
        """
        Holding ID
        """
        self.obj['orderId'] = value
        return self

    def set_amount(self, value: str) -> RedeemReqBuilder:
        """
        Redemption amount
        """
        self.obj['amount'] = value
        return self

    def set_from_account_type(
            self, value: RedeemReq.FromAccountTypeEnum) -> RedeemReqBuilder:
        """
        Account type: MAIN (funding account), TRADE (spot trading account). This parameter is valid only when orderId=ETH2
        """
        self.obj['fromAccountType'] = value
        return self

    def set_confirm_punish_redeem(self, value: str) -> RedeemReqBuilder:
        """
        Confirmation field for early redemption penalty: 1 (confirm early redemption, and the current holding will be fully redeemed). This parameter is valid only for fixed-term products
        """
        self.obj['confirmPunishRedeem'] = value
        return self

    def build(self) -> RedeemReq:
        return RedeemReq(**self.obj)
