# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetPrivateFundingHistoryDataList(BaseModel):
    """
    GetPrivateFundingHistoryDataList

    Attributes:
        id (int): id
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        time_point (int): Time point (milisecond) 
        funding_rate (float): Funding rate 
        mark_price (float): Mark price 
        position_qty (int): Position size
        position_cost (float): Position value at settlement period 
        funding (float): Settled funding fees. A positive number means that the user received the funding fee, and vice versa. 
        settle_currency (str): settlement currency 
        context (str): context
        margin_mode (MarginModeEnum): Margin mode: ISOLATED (isolated), CROSS (cross margin).
    """

    class MarginModeEnum(Enum):
        """
        Attributes:
            ISOLATED: isolated margin
            CROSS: cross margin
        """
        ISOLATED = 'ISOLATED'
        CROSS = 'CROSS'

    id: Optional[int] = Field(default=None, description="id")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    time_point: Optional[int] = Field(default=None,
                                      description="Time point (milisecond) ",
                                      alias="timePoint")
    funding_rate: Optional[float] = Field(default=None,
                                          description="Funding rate ",
                                          alias="fundingRate")
    mark_price: Optional[float] = Field(default=None,
                                        description="Mark price ",
                                        alias="markPrice")
    position_qty: Optional[int] = Field(default=None,
                                        description="Position size",
                                        alias="positionQty")
    position_cost: Optional[float] = Field(
        default=None,
        description="Position value at settlement period ",
        alias="positionCost")
    funding: Optional[float] = Field(
        default=None,
        description=
        "Settled funding fees. A positive number means that the user received the funding fee, and vice versa. "
    )
    settle_currency: Optional[str] = Field(default=None,
                                           description="settlement currency ",
                                           alias="settleCurrency")
    context: Optional[str] = Field(default=None, description="context")
    margin_mode: Optional[MarginModeEnum] = Field(
        default=None,
        description="Margin mode: ISOLATED (isolated), CROSS (cross margin).",
        alias="marginMode")

    __properties: ClassVar[List[str]] = [
        "id", "symbol", "timePoint", "fundingRate", "markPrice", "positionQty",
        "positionCost", "funding", "settleCurrency", "context", "marginMode"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetPrivateFundingHistoryDataList]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetPrivateFundingHistoryDataList]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "symbol": obj.get("symbol"),
            "timePoint": obj.get("timePoint"),
            "fundingRate": obj.get("fundingRate"),
            "markPrice": obj.get("markPrice"),
            "positionQty": obj.get("positionQty"),
            "positionCost": obj.get("positionCost"),
            "funding": obj.get("funding"),
            "settleCurrency": obj.get("settleCurrency"),
            "context": obj.get("context"),
            "marginMode": obj.get("marginMode")
        })
        return _obj
