# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class AllPositionEvent(BaseModel):
    """
    AllPositionEvent

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-221752070) 
        cross_mode (bool): Whether it is cross margin.
        delev_percentage (float): ADL ranking percentile 
        opening_timestamp (int): Open time 
        current_timestamp (int): Current timestamp 
        current_qty (int): Current postion quantity 
        current_cost (float): Current postion value 
        current_comm (float): Current commission 
        unrealised_cost (float): Unrealised value 
        realised_gross_cost (float): Accumulated realised gross profit value 
        realised_cost (float): Current realised position value 
        is_open (bool): Opened position or not 
        mark_price (float): Mark price 
        mark_value (float): Mark Value 
        pos_cost (float): Position value 
        pos_init (float): Inital margin Cross = opening value/cross leverage; isolated = accumulation of initial margin for each transaction 
        pos_margin (float): Bankruptcy cost Cross = mark value * imr; Isolated = position margin (accumulation of initial margin, additional margin, generated funding fees, etc.) 
        realised_gross_pnl (float): Accumulated realised gross profit value 
        realised_pnl (float): Realised profit and loss 
        unrealised_pnl (float): Unrealised profit and loss 
        unrealised_pnl_pcnt (float): Profit-loss ratio of the position 
        unrealised_roe_pcnt (float): Rate of return on investment 
        avg_entry_price (float): Average entry price 
        liquidation_price (float): Liquidation price For Cross Margin, you can refer to the liquidationPrice, and the liquidation is based on the risk rate. 
        bankrupt_price (float): Bankruptcy price For Cross Margin, you can refer to the bankruptPrice, and the liquidation is based on the risk rate. 
        settle_currency (str): Currency used to clear and settle the trades 
        margin_mode (MarginModeEnum): Margin Mode: CROSS，ISOLATED 
        position_side (PositionSideEnum): Position Side 
        leverage (float): Leverage
        auto_deposit (bool): Auto deposit margin or not **Only applicable to Isolated Margin** 
        maint_margin_req (float): Maintenance margin requirement **Only applicable to Isolated Margin** 
        risk_limit (int): Risk limit **Only applicable to Isolated Margin** 
        real_leverage (float): Leverage of the order **Only applicable to Isolated Margin** 
        pos_cross (float): added margin **Only applicable to Isolated Margin** 
        pos_comm (float): Bankruptcy cost **Only applicable to Isolated Margin** 
        pos_loss (float): Funding fees paid out **Only applicable to Isolated Margin** 
        pos_funding (float): The current remaining unsettled funding fee for the position **Only applicable to Isolated Margin** 
        pos_maint (float): Maintenance margin **Only applicable to Isolated Margin** 
        maint_margin (float): Position margin **Only applicable to Isolated Margin** 
        funding_time (int): Funding time
        qty (int): Position size
        funding_rate (float): Funding rate
        funding_fee (float): Funding fees
        ts (int): Funding Fee Settlement Time (nanosecond)
        success (bool): Adjustment isolated margin risk limit level successful or not
        msg (str): Adjustment isolated margin risk limit level failure reason
    """

    class MarginModeEnum(Enum):
        """
        Attributes:
            CROSS: cross margin
            ISOLATED: isolated margin
        """
        CROSS = 'CROSS'
        ISOLATED = 'ISOLATED'

    class PositionSideEnum(Enum):
        """
        Attributes:
            BOTH: One-way position
        """
        BOTH = 'BOTH'

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-221752070) "
    )
    cross_mode: Optional[bool] = Field(
        default=None,
        description="Whether it is cross margin.",
        alias="crossMode")
    delev_percentage: Optional[float] = Field(
        default=None,
        description="ADL ranking percentile ",
        alias="delevPercentage")
    opening_timestamp: Optional[int] = Field(default=None,
                                             description="Open time ",
                                             alias="openingTimestamp")
    current_timestamp: Optional[int] = Field(default=None,
                                             description="Current timestamp ",
                                             alias="currentTimestamp")
    current_qty: Optional[int] = Field(default=None,
                                       description="Current postion quantity ",
                                       alias="currentQty")
    current_cost: Optional[float] = Field(default=None,
                                          description="Current postion value ",
                                          alias="currentCost")
    current_comm: Optional[float] = Field(default=None,
                                          description="Current commission ",
                                          alias="currentComm")
    unrealised_cost: Optional[float] = Field(default=None,
                                             description="Unrealised value ",
                                             alias="unrealisedCost")
    realised_gross_cost: Optional[float] = Field(
        default=None,
        description="Accumulated realised gross profit value ",
        alias="realisedGrossCost")
    realised_cost: Optional[float] = Field(
        default=None,
        description="Current realised position value ",
        alias="realisedCost")
    is_open: Optional[bool] = Field(default=None,
                                    description="Opened position or not ",
                                    alias="isOpen")
    mark_price: Optional[float] = Field(default=None,
                                        description="Mark price ",
                                        alias="markPrice")
    mark_value: Optional[float] = Field(default=None,
                                        description="Mark Value ",
                                        alias="markValue")
    pos_cost: Optional[float] = Field(default=None,
                                      description="Position value ",
                                      alias="posCost")
    pos_init: Optional[float] = Field(
        default=None,
        description=
        "Inital margin Cross = opening value/cross leverage; isolated = accumulation of initial margin for each transaction ",
        alias="posInit")
    pos_margin: Optional[float] = Field(
        default=None,
        description=
        "Bankruptcy cost Cross = mark value * imr; Isolated = position margin (accumulation of initial margin, additional margin, generated funding fees, etc.) ",
        alias="posMargin")
    realised_gross_pnl: Optional[float] = Field(
        default=None,
        description="Accumulated realised gross profit value ",
        alias="realisedGrossPnl")
    realised_pnl: Optional[float] = Field(
        default=None,
        description="Realised profit and loss ",
        alias="realisedPnl")
    unrealised_pnl: Optional[float] = Field(
        default=None,
        description="Unrealised profit and loss ",
        alias="unrealisedPnl")
    unrealised_pnl_pcnt: Optional[float] = Field(
        default=None,
        description="Profit-loss ratio of the position ",
        alias="unrealisedPnlPcnt")
    unrealised_roe_pcnt: Optional[float] = Field(
        default=None,
        description="Rate of return on investment ",
        alias="unrealisedRoePcnt")
    avg_entry_price: Optional[float] = Field(
        default=None,
        description="Average entry price ",
        alias="avgEntryPrice")
    liquidation_price: Optional[float] = Field(
        default=None,
        description=
        "Liquidation price For Cross Margin, you can refer to the liquidationPrice, and the liquidation is based on the risk rate. ",
        alias="liquidationPrice")
    bankrupt_price: Optional[float] = Field(
        default=None,
        description=
        "Bankruptcy price For Cross Margin, you can refer to the bankruptPrice, and the liquidation is based on the risk rate. ",
        alias="bankruptPrice")
    settle_currency: Optional[str] = Field(
        default=None,
        description="Currency used to clear and settle the trades ",
        alias="settleCurrency")
    margin_mode: Optional[MarginModeEnum] = Field(
        default=None,
        description="Margin Mode: CROSS，ISOLATED ",
        alias="marginMode")
    position_side: Optional[PositionSideEnum] = Field(
        default=None, description="Position Side ", alias="positionSide")
    leverage: Optional[float] = Field(default=None, description="Leverage")
    auto_deposit: Optional[bool] = Field(
        default=None,
        description=
        "Auto deposit margin or not **Only applicable to Isolated Margin** ",
        alias="autoDeposit")
    maint_margin_req: Optional[float] = Field(
        default=None,
        description=
        "Maintenance margin requirement **Only applicable to Isolated Margin** ",
        alias="maintMarginReq")
    risk_limit: Optional[int] = Field(
        default=None,
        description="Risk limit **Only applicable to Isolated Margin** ",
        alias="riskLimit")
    real_leverage: Optional[float] = Field(
        default=None,
        description=
        "Leverage of the order **Only applicable to Isolated Margin** ",
        alias="realLeverage")
    pos_cross: Optional[float] = Field(
        default=None,
        description="added margin **Only applicable to Isolated Margin** ",
        alias="posCross")
    pos_comm: Optional[float] = Field(
        default=None,
        description="Bankruptcy cost **Only applicable to Isolated Margin** ",
        alias="posComm")
    pos_loss: Optional[float] = Field(
        default=None,
        description=
        "Funding fees paid out **Only applicable to Isolated Margin** ",
        alias="posLoss")
    pos_funding: Optional[float] = Field(
        default=None,
        description=
        "The current remaining unsettled funding fee for the position **Only applicable to Isolated Margin** ",
        alias="posFunding")
    pos_maint: Optional[float] = Field(
        default=None,
        description=
        "Maintenance margin **Only applicable to Isolated Margin** ",
        alias="posMaint")
    maint_margin: Optional[float] = Field(
        default=None,
        description="Position margin **Only applicable to Isolated Margin** ",
        alias="maintMargin")
    funding_time: Optional[int] = Field(default=None,
                                        description="Funding time",
                                        alias="fundingTime")
    qty: Optional[int] = Field(default=None, description="Position size")
    funding_rate: Optional[float] = Field(default=None,
                                          description="Funding rate",
                                          alias="fundingRate")
    funding_fee: Optional[float] = Field(default=None,
                                         description="Funding fees",
                                         alias="fundingFee")
    ts: Optional[int] = Field(
        default=None, description="Funding Fee Settlement Time (nanosecond)")
    success: Optional[bool] = Field(
        default=None,
        description=
        "Adjustment isolated margin risk limit level successful or not")
    msg: Optional[str] = Field(
        default=None,
        description="Adjustment isolated margin risk limit level failure reason"
    )

    __properties: ClassVar[List[str]] = [
        "symbol", "crossMode", "delevPercentage", "openingTimestamp",
        "currentTimestamp", "currentQty", "currentCost", "currentComm",
        "unrealisedCost", "realisedGrossCost", "realisedCost", "isOpen",
        "markPrice", "markValue", "posCost", "posInit", "posMargin",
        "realisedGrossPnl", "realisedPnl", "unrealisedPnl",
        "unrealisedPnlPcnt", "unrealisedRoePcnt", "avgEntryPrice",
        "liquidationPrice", "bankruptPrice", "settleCurrency", "marginMode",
        "positionSide", "leverage", "autoDeposit", "maintMarginReq",
        "riskLimit", "realLeverage", "posCross", "posComm", "posLoss",
        "posFunding", "posMaint", "maintMargin", "fundingTime", "qty",
        "fundingRate", "fundingFee", "ts", "success", "msg"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AllPositionEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AllPositionEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "crossMode":
            obj.get("crossMode"),
            "delevPercentage":
            obj.get("delevPercentage"),
            "openingTimestamp":
            obj.get("openingTimestamp"),
            "currentTimestamp":
            obj.get("currentTimestamp"),
            "currentQty":
            obj.get("currentQty"),
            "currentCost":
            obj.get("currentCost"),
            "currentComm":
            obj.get("currentComm"),
            "unrealisedCost":
            obj.get("unrealisedCost"),
            "realisedGrossCost":
            obj.get("realisedGrossCost"),
            "realisedCost":
            obj.get("realisedCost"),
            "isOpen":
            obj.get("isOpen"),
            "markPrice":
            obj.get("markPrice"),
            "markValue":
            obj.get("markValue"),
            "posCost":
            obj.get("posCost"),
            "posInit":
            obj.get("posInit"),
            "posMargin":
            obj.get("posMargin"),
            "realisedGrossPnl":
            obj.get("realisedGrossPnl"),
            "realisedPnl":
            obj.get("realisedPnl"),
            "unrealisedPnl":
            obj.get("unrealisedPnl"),
            "unrealisedPnlPcnt":
            obj.get("unrealisedPnlPcnt"),
            "unrealisedRoePcnt":
            obj.get("unrealisedRoePcnt"),
            "avgEntryPrice":
            obj.get("avgEntryPrice"),
            "liquidationPrice":
            obj.get("liquidationPrice"),
            "bankruptPrice":
            obj.get("bankruptPrice"),
            "settleCurrency":
            obj.get("settleCurrency"),
            "marginMode":
            obj.get("marginMode"),
            "positionSide":
            obj.get("positionSide"),
            "leverage":
            obj.get("leverage"),
            "autoDeposit":
            obj.get("autoDeposit"),
            "maintMarginReq":
            obj.get("maintMarginReq"),
            "riskLimit":
            obj.get("riskLimit"),
            "realLeverage":
            obj.get("realLeverage"),
            "posCross":
            obj.get("posCross"),
            "posComm":
            obj.get("posComm"),
            "posLoss":
            obj.get("posLoss"),
            "posFunding":
            obj.get("posFunding"),
            "posMaint":
            obj.get("posMaint"),
            "maintMargin":
            obj.get("maintMargin"),
            "fundingTime":
            obj.get("fundingTime"),
            "qty":
            obj.get("qty"),
            "fundingRate":
            obj.get("fundingRate"),
            "fundingFee":
            obj.get("fundingFee"),
            "ts":
            obj.get("ts"),
            "success":
            obj.get("success"),
            "msg":
            obj.get("msg")
        })
        return _obj


AllPositionEventCallback = Callable[[str, str, AllPositionEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (AllPositionEvent): event data
"""


class AllPositionEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: AllPositionEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = AllPositionEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
