# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class BalanceEvent(BaseModel):
    """
    BalanceEvent

    Attributes:
        cross_pos_margin (str): Margin of the cross margin position
        isolated_order_margin (str): Margin of the isolated margin order
        hold_balance (str): Frozen Balance
        equity (str): Equity
        version (str): Version. When holding a cross margin position, the available balance may change with fluctuations in the mark price, leading to discrepancies in the available balance for the same version number.
        available_balance (str): Available Balance
        isolated_pos_margin (str): Margin of the isolated margin position, including isolated margin funding fees
        wallet_balance (str): Wallet Balance
        isolated_funding_fee_margin (str): Isolated margin funding fee
        cross_un_pnl (str): Unrealized PNL in cross margin mode
        total_cross_margin (str): Total margin under cross margin mode
        currency (str): Currency Symbol
        isolated_un_pnl (str):  Unrealized PNL in isolated margin mode
        cross_order_margin (str): Margin of the cross margin order
        timestamp (str): Last modified time
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    cross_pos_margin: Optional[str] = Field(
        default=None,
        description="Margin of the cross margin position",
        alias="crossPosMargin")
    isolated_order_margin: Optional[str] = Field(
        default=None,
        description="Margin of the isolated margin order",
        alias="isolatedOrderMargin")
    hold_balance: Optional[str] = Field(default=None,
                                        description="Frozen Balance",
                                        alias="holdBalance")
    equity: Optional[str] = Field(default=None, description="Equity")
    version: Optional[str] = Field(
        default=None,
        description=
        "Version. When holding a cross margin position, the available balance may change with fluctuations in the mark price, leading to discrepancies in the available balance for the same version number."
    )
    available_balance: Optional[str] = Field(default=None,
                                             description="Available Balance",
                                             alias="availableBalance")
    isolated_pos_margin: Optional[str] = Field(
        default=None,
        description=
        "Margin of the isolated margin position, including isolated margin funding fees",
        alias="isolatedPosMargin")
    wallet_balance: Optional[str] = Field(default=None,
                                          description="Wallet Balance",
                                          alias="walletBalance")
    isolated_funding_fee_margin: Optional[str] = Field(
        default=None,
        description="Isolated margin funding fee",
        alias="isolatedFundingFeeMargin")
    cross_un_pnl: Optional[str] = Field(
        default=None,
        description="Unrealized PNL in cross margin mode",
        alias="crossUnPnl")
    total_cross_margin: Optional[str] = Field(
        default=None,
        description="Total margin under cross margin mode",
        alias="totalCrossMargin")
    currency: Optional[str] = Field(default=None,
                                    description="Currency Symbol")
    isolated_un_pnl: Optional[str] = Field(
        default=None,
        description=" Unrealized PNL in isolated margin mode",
        alias="isolatedUnPnl")
    cross_order_margin: Optional[str] = Field(
        default=None,
        description="Margin of the cross margin order",
        alias="crossOrderMargin")
    timestamp: Optional[str] = Field(default=None,
                                     description="Last modified time")

    __properties: ClassVar[List[str]] = [
        "crossPosMargin", "isolatedOrderMargin", "holdBalance", "equity",
        "version", "availableBalance", "isolatedPosMargin", "walletBalance",
        "isolatedFundingFeeMargin", "crossUnPnl", "totalCrossMargin",
        "currency", "isolatedUnPnl", "crossOrderMargin", "timestamp"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[BalanceEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[BalanceEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "crossPosMargin":
            obj.get("crossPosMargin"),
            "isolatedOrderMargin":
            obj.get("isolatedOrderMargin"),
            "holdBalance":
            obj.get("holdBalance"),
            "equity":
            obj.get("equity"),
            "version":
            obj.get("version"),
            "availableBalance":
            obj.get("availableBalance"),
            "isolatedPosMargin":
            obj.get("isolatedPosMargin"),
            "walletBalance":
            obj.get("walletBalance"),
            "isolatedFundingFeeMargin":
            obj.get("isolatedFundingFeeMargin"),
            "crossUnPnl":
            obj.get("crossUnPnl"),
            "totalCrossMargin":
            obj.get("totalCrossMargin"),
            "currency":
            obj.get("currency"),
            "isolatedUnPnl":
            obj.get("isolatedUnPnl"),
            "crossOrderMargin":
            obj.get("crossOrderMargin"),
            "timestamp":
            obj.get("timestamp")
        })
        return _obj


BalanceEventCallback = Callable[[str, str, BalanceEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (BalanceEvent): event data
"""


class BalanceEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: BalanceEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = BalanceEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
