# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class InstrumentEvent(BaseModel):
    """
    InstrumentEvent

    Attributes:
        granularity (int): Granularity (predicted funding rate: 1-min granularity: 60000; Funding rate: 8-hours granularity: 28800000. )
        funding_rate (float): 
        timestamp (int): 
        mark_price (float): 
        index_price (float): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    granularity: Optional[int] = Field(
        default=None,
        description=
        "Granularity (predicted funding rate: 1-min granularity: 60000; Funding rate: 8-hours granularity: 28800000. )"
    )
    funding_rate: Optional[float] = Field(default=None, alias="fundingRate")
    timestamp: Optional[int] = None
    mark_price: Optional[float] = Field(default=None, alias="markPrice")
    index_price: Optional[float] = Field(default=None, alias="indexPrice")

    __properties: ClassVar[List[str]] = [
        "granularity", "fundingRate", "timestamp", "markPrice", "indexPrice"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[InstrumentEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[InstrumentEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "granularity": obj.get("granularity"),
            "fundingRate": obj.get("fundingRate"),
            "timestamp": obj.get("timestamp"),
            "markPrice": obj.get("markPrice"),
            "indexPrice": obj.get("indexPrice")
        })
        return _obj


InstrumentEventCallback = Callable[[str, str, InstrumentEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (InstrumentEvent): event data
"""


class InstrumentEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: InstrumentEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = InstrumentEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
