# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class TickerV1Event(BaseModel):
    """
    TickerV1Event

    Attributes:
        symbol (str): 
        sequence (int): 
        side (str): 
        size (int): 
        price (str): 
        best_bid_size (int): 
        best_bid_price (str): 
        best_ask_price (str): 
        trade_id (str): 
        best_ask_size (int): 
        ts (int): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    symbol: Optional[str] = None
    sequence: Optional[int] = None
    side: Optional[str] = None
    size: Optional[int] = None
    price: Optional[str] = None
    best_bid_size: Optional[int] = Field(default=None, alias="bestBidSize")
    best_bid_price: Optional[str] = Field(default=None, alias="bestBidPrice")
    best_ask_price: Optional[str] = Field(default=None, alias="bestAskPrice")
    trade_id: Optional[str] = Field(default=None, alias="tradeId")
    best_ask_size: Optional[int] = Field(default=None, alias="bestAskSize")
    ts: Optional[int] = None

    __properties: ClassVar[List[str]] = [
        "symbol", "sequence", "side", "size", "price", "bestBidSize",
        "bestBidPrice", "bestAskPrice", "tradeId", "bestAskSize", "ts"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[TickerV1Event]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[TickerV1Event]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "sequence": obj.get("sequence"),
            "side": obj.get("side"),
            "size": obj.get("size"),
            "price": obj.get("price"),
            "bestBidSize": obj.get("bestBidSize"),
            "bestBidPrice": obj.get("bestBidPrice"),
            "bestAskPrice": obj.get("bestAskPrice"),
            "tradeId": obj.get("tradeId"),
            "bestAskSize": obj.get("bestAskSize"),
            "ts": obj.get("ts")
        })
        return _obj


TickerV1EventCallback = Callable[[str, str, TickerV1Event], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (TickerV1Event): event data
"""


class TickerV1EventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: TickerV1EventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = TickerV1Event.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
