# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketService
from .model_announcement_event import AnnouncementEventCallback, AnnouncementEventCallbackWrapper
from .model_execution_event import ExecutionEventCallback, ExecutionEventCallbackWrapper
from .model_instrument_event import InstrumentEventCallback, InstrumentEventCallbackWrapper
from .model_klines_event import KlinesEventCallback, KlinesEventCallbackWrapper
from .model_orderbook_increment_event import OrderbookIncrementEventCallback, OrderbookIncrementEventCallbackWrapper
from .model_orderbook_level50_event import OrderbookLevel50EventCallback, OrderbookLevel50EventCallbackWrapper
from .model_orderbook_level5_event import OrderbookLevel5EventCallback, OrderbookLevel5EventCallbackWrapper
from .model_symbol_snapshot_event import SymbolSnapshotEventCallback, SymbolSnapshotEventCallbackWrapper
from .model_ticker_v1_event import TickerV1EventCallback, TickerV1EventCallbackWrapper
from .model_ticker_v2_event import TickerV2EventCallback, TickerV2EventCallbackWrapper


class FuturesPublicWS(ABC):

    @abstractmethod
    def announcement(self, symbol: str,
                     callback: AnnouncementEventCallback) -> str:
        """
        summary: announcement
        description: Subscribe this topic to get Funding Fee Settlement.
        push frequency: Settlement is made every 8 hours, real-time push
        """
        pass

    @abstractmethod
    def execution(self, symbol: str, callback: ExecutionEventCallback) -> str:
        """
        summary: Match execution data.
        description: For each order executed, the system will send you the match messages in the format as following.
        push frequency: realtime
        """
        pass

    @abstractmethod
    def instrument(self, symbol: str,
                   callback: InstrumentEventCallback) -> str:
        """
        summary: instrument
        description: Subscribe this topic to get the mark Price, index Price or funding fee Rate
        push frequency: mark.index.price 1s, funding.rate 1min
        """
        pass

    @abstractmethod
    def klines(self, symbol: str, type: str,
               callback: KlinesEventCallback) -> str:
        """
        summary: Klines
        description: Subscribe to this topic to get K-Line data.
        push frequency: 1s
        """
        pass

    @abstractmethod
    def orderbook_increment(self, symbol: str,
                            callback: OrderbookIncrementEventCallback) -> str:
        """
        summary: Orderbook - Increment
        description: The system will return the increment change orderbook data(All depth), If there is no change in the market, data will not be pushed
        push frequency: realtime
        """
        pass

    @abstractmethod
    def orderbook_level50(self, symbol: str,
                          callback: OrderbookLevel50EventCallback) -> str:
        """
        summary: Orderbook - Level50
        description: The depth50 market data.
        push frequency: 100ms
        """
        pass

    @abstractmethod
    def orderbook_level5(self, symbol: str,
                         callback: OrderbookLevel5EventCallback) -> str:
        """
        summary: Orderbook - Level5
        description: The system will return the 5 best ask/bid orders data, If there is no change in the market, data will not be pushed
        push frequency: 100ms
        """
        pass

    @abstractmethod
    def symbol_snapshot(self, symbol: str,
                        callback: SymbolSnapshotEventCallback) -> str:
        """
        summary: Symbol Snapshot
        description: Get symbol&#39;s snapshot.
        push frequency: 5000ms
        """
        pass

    @abstractmethod
    def ticker_v1(self, symbol: str, callback: TickerV1EventCallback) -> str:
        """
        summary: Get Ticker(not recommended)
        description: Subscribe this topic to get the realtime push of BBO changes.It is not recommended to use this topic any more. For real-time ticker information, please subscribe /contractMarket/tickerV2:{symbol}.
        push frequency: realtime
        """
        pass

    @abstractmethod
    def ticker_v2(self, symbol: str, callback: TickerV2EventCallback) -> str:
        """
        summary: Get Ticker V2
        description: Subscribe this topic to get the realtime push of BBO changes. After subscription, when there are changes in the order book（Not necessarily ask1/bid1 changes）, the system will push the real-time ticker symbol information to you.
        push frequency: realtime
        """
        pass

    @abstractmethod
    def unsubscribe(self, id: str):
        pass

    @abstractmethod
    def start(self):
        pass

    @abstractmethod
    def stop(self):
        pass


class FuturesPublicWSImpl(FuturesPublicWS):

    def __init__(self, transport: WebSocketService):
        self.transport = transport

    def announcement(self, symbol: str,
                     callback: AnnouncementEventCallback) -> str:
        topic_prefix = "/contract/announcement"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args, AnnouncementEventCallbackWrapper(callback))

    def execution(self, symbol: str, callback: ExecutionEventCallback) -> str:
        topic_prefix = "/contractMarket/execution"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args, ExecutionEventCallbackWrapper(callback))

    def instrument(self, symbol: str,
                   callback: InstrumentEventCallback) -> str:
        topic_prefix = "/contract/instrument"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args, InstrumentEventCallbackWrapper(callback))

    def klines(self, symbol: str, type: str,
               callback: KlinesEventCallback) -> str:
        topic_prefix = "/contractMarket/limitCandle"

        args = ["_".join([
            symbol,
            type,
        ])]

        return self.transport.subscribe(topic_prefix, args,
                                        KlinesEventCallbackWrapper(callback))

    def orderbook_increment(self, symbol: str,
                            callback: OrderbookIncrementEventCallback) -> str:
        topic_prefix = "/contractMarket/level2"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args,
            OrderbookIncrementEventCallbackWrapper(callback))

    def orderbook_level50(self, symbol: str,
                          callback: OrderbookLevel50EventCallback) -> str:
        topic_prefix = "/contractMarket/level2Depth50"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args, OrderbookLevel50EventCallbackWrapper(callback))

    def orderbook_level5(self, symbol: str,
                         callback: OrderbookLevel5EventCallback) -> str:
        topic_prefix = "/contractMarket/level2Depth5"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args, OrderbookLevel5EventCallbackWrapper(callback))

    def symbol_snapshot(self, symbol: str,
                        callback: SymbolSnapshotEventCallback) -> str:
        topic_prefix = "/contractMarket/snapshot"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args, SymbolSnapshotEventCallbackWrapper(callback))

    def ticker_v1(self, symbol: str, callback: TickerV1EventCallback) -> str:
        topic_prefix = "/contractMarket/ticker"

        args = [symbol]

        return self.transport.subscribe(topic_prefix, args,
                                        TickerV1EventCallbackWrapper(callback))

    def ticker_v2(self, symbol: str, callback: TickerV2EventCallback) -> str:
        topic_prefix = "/contractMarket/tickerV2"

        args = [symbol]

        return self.transport.subscribe(topic_prefix, args,
                                        TickerV2EventCallbackWrapper(callback))

    def unsubscribe(self, id: str):
        self.transport.unsubscribe(id)

    def start(self):
        self.transport.start()

    def stop(self):
        self.transport.stop()
