# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetPartOrderBookResp(BaseModel, Response):
    """
    GetPartOrderBookResp

    Attributes:
        sequence (int): Sequence number
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        bids (list[list[float]]): bids, from high to low
        asks (list[list[float]]): asks, from low to high
        ts (int): Timestamp(nanosecond)
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    sequence: Optional[int] = Field(default=None,
                                    description="Sequence number")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    bids: Optional[List[List[float]]] = Field(
        default=None, description="bids, from high to low")
    asks: Optional[List[List[float]]] = Field(
        default=None, description="asks, from low to high")
    ts: Optional[int] = Field(default=None,
                              description="Timestamp(nanosecond)")

    __properties: ClassVar[List[str]] = [
        "sequence", "symbol", "bids", "asks", "ts"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetPartOrderBookResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetPartOrderBookResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sequence": obj.get("sequence"),
            "symbol": obj.get("symbol"),
            "bids": obj.get("bids"),
            "asks": obj.get("asks"),
            "ts": obj.get("ts")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
