# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_add_order_req import AddOrderReq
from .model_add_order_resp import AddOrderResp
from .model_add_order_test_req import AddOrderTestReq
from .model_add_order_test_resp import AddOrderTestResp
from .model_add_tpsl_order_req import AddTpslOrderReq
from .model_add_tpsl_order_resp import AddTpslOrderResp
from .model_batch_add_orders_req import BatchAddOrdersReq
from .model_batch_add_orders_resp import BatchAddOrdersResp
from .model_batch_cancel_orders_req import BatchCancelOrdersReq
from .model_batch_cancel_orders_resp import BatchCancelOrdersResp
from .model_cancel_all_orders_v1_req import CancelAllOrdersV1Req
from .model_cancel_all_orders_v1_resp import CancelAllOrdersV1Resp
from .model_cancel_all_orders_v3_req import CancelAllOrdersV3Req
from .model_cancel_all_orders_v3_resp import CancelAllOrdersV3Resp
from .model_cancel_all_stop_orders_req import CancelAllStopOrdersReq
from .model_cancel_all_stop_orders_resp import CancelAllStopOrdersResp
from .model_cancel_order_by_client_oid_req import CancelOrderByClientOidReq
from .model_cancel_order_by_client_oid_resp import CancelOrderByClientOidResp
from .model_cancel_order_by_id_req import CancelOrderByIdReq
from .model_cancel_order_by_id_resp import CancelOrderByIdResp
from .model_get_open_order_value_req import GetOpenOrderValueReq
from .model_get_open_order_value_resp import GetOpenOrderValueResp
from .model_get_order_by_client_oid_req import GetOrderByClientOidReq
from .model_get_order_by_client_oid_resp import GetOrderByClientOidResp
from .model_get_order_by_order_id_req import GetOrderByOrderIdReq
from .model_get_order_by_order_id_resp import GetOrderByOrderIdResp
from .model_get_order_list_req import GetOrderListReq
from .model_get_order_list_resp import GetOrderListResp
from .model_get_recent_closed_orders_req import GetRecentClosedOrdersReq
from .model_get_recent_closed_orders_resp import GetRecentClosedOrdersResp
from .model_get_recent_trade_history_req import GetRecentTradeHistoryReq
from .model_get_recent_trade_history_resp import GetRecentTradeHistoryResp
from .model_get_stop_order_list_req import GetStopOrderListReq
from .model_get_stop_order_list_resp import GetStopOrderListResp
from .model_get_trade_history_req import GetTradeHistoryReq
from .model_get_trade_history_resp import GetTradeHistoryResp
from typing_extensions import deprecated


class OrderAPI(ABC):

    @abstractmethod
    def add_order(self, req: AddOrderReq, **kwargs: Any) -> AddOrderResp:
        """
        summary: Add Order
        description: Place order to the futures trading system, you can place two major types of orders: limit and market. Orders can only be placed if your account has sufficient funds. Once an order is placed, your funds will be put on hold for the duration of the order. The amount of funds on hold depends on the order type and parameters specified.
        documentation: https://www.kucoin.com/docs-new/api-3470235
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def add_order_test(self, req: AddOrderTestReq,
                       **kwargs: Any) -> AddOrderTestResp:
        """
        summary: Add Order Test
        description: Place order to the futures trading system just for validation
        documentation: https://www.kucoin.com/docs-new/api-3470238
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def batch_add_orders(self, req: BatchAddOrdersReq,
                         **kwargs: Any) -> BatchAddOrdersResp:
        """
        summary: Batch Add Orders
        description: Place multiple order to the futures trading system, you can place two major types of orders: limit and market. Orders can only be placed if your account has sufficient funds. Once an order is placed, your funds will be put on hold for the duration of the order. The amount of funds on hold depends on the order type and parameters specified. You can place up to 20 orders at one time, including limit orders, market orders, and stop orders  Please be noted that the system would hold the fees from the orders entered the orderbook in advance.
        documentation: https://www.kucoin.com/docs-new/api-3470236
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 20      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def add_tpsl_order(self, req: AddTpslOrderReq,
                       **kwargs: Any) -> AddTpslOrderResp:
        """
        summary: Add Take Profit And Stop Loss Order
        description: Place take profit and stop loss order supports both take-profit and stop-loss functions, and other functions are exactly the same as the place order interface.
        documentation: https://www.kucoin.com/docs-new/api-3470237
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_order_by_id(self, req: CancelOrderByIdReq,
                           **kwargs: Any) -> CancelOrderByIdResp:
        """
        summary: Cancel Order By OrderId
        description: Cancel order by system generated orderId.
        documentation: https://www.kucoin.com/docs-new/api-3470239
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 1       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_order_by_client_oid(
            self, req: CancelOrderByClientOidReq,
            **kwargs: Any) -> CancelOrderByClientOidResp:
        """
        summary: Cancel Order By ClientOid
        description: Cancel order by client defined orderId.
        documentation: https://www.kucoin.com/docs-new/api-3470240
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 1       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def batch_cancel_orders(self, req: BatchCancelOrdersReq,
                            **kwargs: Any) -> BatchCancelOrdersResp:
        """
        summary: Batch Cancel Orders
        description: Cancel a bach of orders by client defined orderId or system generated orderId
        documentation: https://www.kucoin.com/docs-new/api-3470241
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 20      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_all_orders_v3(self, req: CancelAllOrdersV3Req,
                             **kwargs: Any) -> CancelAllOrdersV3Resp:
        """
        summary: Cancel All Orders
        description: Cancel all open orders (excluding stop orders). The response is a list of orderIDs of the canceled orders.
        documentation: https://www.kucoin.com/docs-new/api-3470242
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 10      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_all_stop_orders(self, req: CancelAllStopOrdersReq,
                               **kwargs: Any) -> CancelAllStopOrdersResp:
        """
        summary: Cancel All Stop orders
        description: Cancel all untriggered stop orders. The response is a list of orderIDs of the canceled stop orders. To cancel triggered stop orders, please use &#39;Cancel Multiple Futures Limit orders&#39;.
        documentation: https://www.kucoin.com/docs-new/api-3470243
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 15      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_order_by_order_id(self, req: GetOrderByOrderIdReq,
                              **kwargs: Any) -> GetOrderByOrderIdResp:
        """
        summary: Get Order By OrderId
        description: Get a single order by order id (including a stop order).
        documentation: https://www.kucoin.com/docs-new/api-3470245
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_order_by_client_oid(self, req: GetOrderByClientOidReq,
                                **kwargs: Any) -> GetOrderByClientOidResp:
        """
        summary: Get Order By ClientOid
        description: Get a single order by client order id (including a stop order).
        documentation: https://www.kucoin.com/docs-new/api-3470352
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_order_list(self, req: GetOrderListReq,
                       **kwargs: Any) -> GetOrderListResp:
        """
        summary: Get Order List
        description: List your current orders.
        documentation: https://www.kucoin.com/docs-new/api-3470244
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_recent_closed_orders(self, req: GetRecentClosedOrdersReq,
                                 **kwargs: Any) -> GetRecentClosedOrdersResp:
        """
        summary: Get Recent Closed Orders
        description: Get a list of recent 1000 closed orders in the last 24 hours.  If you need to get your recent traded order history with low latency, you may query this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470246
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_stop_order_list(self, req: GetStopOrderListReq,
                            **kwargs: Any) -> GetStopOrderListResp:
        """
        summary: Get Stop Order List
        description: Get the un-triggered stop orders list. Stop orders that have been triggered can be queried through the general order interface
        documentation: https://www.kucoin.com/docs-new/api-3470247
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 6       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_open_order_value(self, req: GetOpenOrderValueReq,
                             **kwargs: Any) -> GetOpenOrderValueResp:
        """
        summary: Get Open Order Value
        description: You can query this endpoint to get the the total number and value of the all your active orders.
        documentation: https://www.kucoin.com/docs-new/api-3470250
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 10      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_recent_trade_history(self, req: GetRecentTradeHistoryReq,
                                 **kwargs: Any) -> GetRecentTradeHistoryResp:
        """
        summary: Get Recent Trade History
        description: Get a list of recent 1000 fills in the last 24 hours. If you need to get your recent traded order history with low latency, you may query this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470249
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 3       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_trade_history(self, req: GetTradeHistoryReq,
                          **kwargs: Any) -> GetTradeHistoryResp:
        """
        summary: Get Trade History
        description: Get a list of recent fills. If you need to get your recent trade history with low latency, please query endpoint Get List of Orders Completed in 24h. The requested data is not real-time.
        documentation: https://www.kucoin.com/docs-new/api-3470248
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def cancel_all_orders_v1(self, req: CancelAllOrdersV1Req,
                             **kwargs: Any) -> CancelAllOrdersV1Resp:
        """
        summary: Cancel All Orders - V1
        description: Cancel all open orders (excluding stop orders). The response is a list of orderIDs of the canceled orders.
        documentation: https://www.kucoin.com/docs-new/api-3470362
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 200     |
        +---------------------+---------+
        """
        pass


class OrderAPIImpl(OrderAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def add_order(self, req: AddOrderReq, **kwargs: Any) -> AddOrderResp:
        return self.transport.call("futures", False, "POST", "/api/v1/orders",
                                   req, AddOrderResp(), False, **kwargs)

    def add_order_test(self, req: AddOrderTestReq,
                       **kwargs: Any) -> AddOrderTestResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/orders/test", req,
                                   AddOrderTestResp(), False, **kwargs)

    def batch_add_orders(self, req: BatchAddOrdersReq,
                         **kwargs: Any) -> BatchAddOrdersResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/orders/multi", req,
                                   BatchAddOrdersResp(), False, **kwargs)

    def add_tpsl_order(self, req: AddTpslOrderReq,
                       **kwargs: Any) -> AddTpslOrderResp:
        return self.transport.call("futures", False,
                                   "POST", "/api/v1/st-orders", req,
                                   AddTpslOrderResp(), False, **kwargs)

    def cancel_order_by_id(self, req: CancelOrderByIdReq,
                           **kwargs: Any) -> CancelOrderByIdResp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v1/orders/{orderId}", req,
                                   CancelOrderByIdResp(), False, **kwargs)

    def cancel_order_by_client_oid(
            self, req: CancelOrderByClientOidReq,
            **kwargs: Any) -> CancelOrderByClientOidResp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v1/orders/client-order/{clientOid}",
                                   req, CancelOrderByClientOidResp(), False,
                                   **kwargs)

    def batch_cancel_orders(self, req: BatchCancelOrdersReq,
                            **kwargs: Any) -> BatchCancelOrdersResp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v1/orders/multi-cancel", req,
                                   BatchCancelOrdersResp(), True, **kwargs)

    def cancel_all_orders_v3(self, req: CancelAllOrdersV3Req,
                             **kwargs: Any) -> CancelAllOrdersV3Resp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v3/orders", req,
                                   CancelAllOrdersV3Resp(), False, **kwargs)

    def cancel_all_stop_orders(self, req: CancelAllStopOrdersReq,
                               **kwargs: Any) -> CancelAllStopOrdersResp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v1/stopOrders", req,
                                   CancelAllStopOrdersResp(), False, **kwargs)

    def get_order_by_order_id(self, req: GetOrderByOrderIdReq,
                              **kwargs: Any) -> GetOrderByOrderIdResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/orders/{order-id}", req,
                                   GetOrderByOrderIdResp(), False, **kwargs)

    def get_order_by_client_oid(self, req: GetOrderByClientOidReq,
                                **kwargs: Any) -> GetOrderByClientOidResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/orders/byClientOid", req,
                                   GetOrderByClientOidResp(), False, **kwargs)

    def get_order_list(self, req: GetOrderListReq,
                       **kwargs: Any) -> GetOrderListResp:
        return self.transport.call("futures", False, "GET", "/api/v1/orders",
                                   req, GetOrderListResp(), False, **kwargs)

    def get_recent_closed_orders(self, req: GetRecentClosedOrdersReq,
                                 **kwargs: Any) -> GetRecentClosedOrdersResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/recentDoneOrders", req,
                                   GetRecentClosedOrdersResp(), False,
                                   **kwargs)

    def get_stop_order_list(self, req: GetStopOrderListReq,
                            **kwargs: Any) -> GetStopOrderListResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/stopOrders", req,
                                   GetStopOrderListResp(), False, **kwargs)

    def get_open_order_value(self, req: GetOpenOrderValueReq,
                             **kwargs: Any) -> GetOpenOrderValueResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/openOrderStatistics", req,
                                   GetOpenOrderValueResp(), False, **kwargs)

    def get_recent_trade_history(self, req: GetRecentTradeHistoryReq,
                                 **kwargs: Any) -> GetRecentTradeHistoryResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/recentFills", req,
                                   GetRecentTradeHistoryResp(), False,
                                   **kwargs)

    def get_trade_history(self, req: GetTradeHistoryReq,
                          **kwargs: Any) -> GetTradeHistoryResp:
        return self.transport.call("futures", False, "GET", "/api/v1/fills",
                                   req, GetTradeHistoryResp(), False, **kwargs)

    def cancel_all_orders_v1(self, req: CancelAllOrdersV1Req,
                             **kwargs: Any) -> CancelAllOrdersV1Resp:
        return self.transport.call("futures", False, "DELETE",
                                   "/api/v1/orders", req,
                                   CancelAllOrdersV1Resp(), False, **kwargs)
