# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_batch_cancel_orders_client_oids_list import BatchCancelOrdersClientOidsList


class BatchCancelOrdersReq(BaseModel):
    """
    BatchCancelOrdersReq

    Attributes:
        order_ids_list (list[str]): the list of orderId
        client_oids_list (list[BatchCancelOrdersClientOidsList]): the list of client orderId
    """

    order_ids_list: Optional[List[str]] = Field(
        default=None, description="the list of orderId", alias="orderIdsList")
    client_oids_list: Optional[List[BatchCancelOrdersClientOidsList]] = Field(
        default=None,
        description="the list of client orderId",
        alias="clientOidsList")

    __properties: ClassVar[List[str]] = ["orderIdsList", "clientOidsList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[BatchCancelOrdersReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in client_oids_list (list)
        _items = []
        if self.client_oids_list:
            for _item_client_oids_list in self.client_oids_list:
                if _item_client_oids_list:
                    _items.append(_item_client_oids_list.to_dict())
            _dict['clientOidsList'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[BatchCancelOrdersReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderIdsList":
            obj.get("orderIdsList"),
            "clientOidsList": [
                BatchCancelOrdersClientOidsList.from_dict(_item)
                for _item in obj["clientOidsList"]
            ] if obj.get("clientOidsList") is not None else None
        })
        return _obj


class BatchCancelOrdersReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_order_ids_list(self,
                           value: list[str]) -> BatchCancelOrdersReqBuilder:
        """
        the list of orderId
        """
        self.obj['orderIdsList'] = value
        return self

    def set_client_oids_list(
        self, value: list[BatchCancelOrdersClientOidsList]
    ) -> BatchCancelOrdersReqBuilder:
        """
        the list of client orderId
        """
        self.obj['clientOidsList'] = value
        return self

    def build(self) -> BatchCancelOrdersReq:
        return BatchCancelOrdersReq(**self.obj)
