# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetOrderListReq(BaseModel):
    """
    GetOrderListReq

    Attributes:
        status (StatusEnum): active or done, done as default. Only list orders for a specific status
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        side (SideEnum): buy or sell
        type (TypeEnum): limit, market, limit_stop or market_stop
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current request page, The default currentPage is 1
        page_size (int): pageSize, The default pageSize is 50, The maximum cannot exceed 1000
    """

    class StatusEnum(Enum):
        """
        Attributes:
            ACTIVE: 
            DONE: 
        """
        ACTIVE = 'active'
        DONE = 'done'

    class SideEnum(Enum):
        """
        Attributes:
            BUY: 
            SELL: 
        """
        BUY = 'buy'
        SELL = 'sell'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: 
            MARKET: 
        """
        LIMIT = 'limit'
        MARKET = 'market'

    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "active or done, done as default. Only list orders for a specific status"
    )
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    side: Optional[SideEnum] = Field(default=None, description="buy or sell")
    type: Optional[TypeEnum] = Field(
        default=None, description="limit, market, limit_stop or market_stop")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(
        default=None,
        description="Current request page, The default currentPage is 1",
        alias="currentPage")
    page_size: Optional[int] = Field(
        default=None,
        description=
        "pageSize, The default pageSize is 50, The maximum cannot exceed 1000",
        alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "status", "symbol", "side", "type", "startAt", "endAt", "currentPage",
        "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetOrderListReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetOrderListReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "symbol": obj.get("symbol"),
            "side": obj.get("side"),
            "type": obj.get("type"),
            "startAt": obj.get("startAt"),
            "endAt": obj.get("endAt"),
            "currentPage": obj.get("currentPage"),
            "pageSize": obj.get("pageSize")
        })
        return _obj


class GetOrderListReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_status(
            self, value: GetOrderListReq.StatusEnum) -> GetOrderListReqBuilder:
        """
        active or done, done as default. Only list orders for a specific status
        """
        self.obj['status'] = value
        return self

    def set_symbol(self, value: str) -> GetOrderListReqBuilder:
        """
        Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_side(self,
                 value: GetOrderListReq.SideEnum) -> GetOrderListReqBuilder:
        """
        buy or sell
        """
        self.obj['side'] = value
        return self

    def set_type(self,
                 value: GetOrderListReq.TypeEnum) -> GetOrderListReqBuilder:
        """
        limit, market, limit_stop or market_stop
        """
        self.obj['type'] = value
        return self

    def set_start_at(self, value: int) -> GetOrderListReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetOrderListReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetOrderListReqBuilder:
        """
        Current request page, The default currentPage is 1
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetOrderListReqBuilder:
        """
        pageSize, The default pageSize is 50, The maximum cannot exceed 1000
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetOrderListReq:
        return GetOrderListReq(**self.obj)
