# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_add_isolated_margin_req import AddIsolatedMarginReq
from .model_add_isolated_margin_resp import AddIsolatedMarginResp
from .model_get_cross_margin_leverage_req import GetCrossMarginLeverageReq
from .model_get_cross_margin_leverage_resp import GetCrossMarginLeverageResp
from .model_get_isolated_margin_risk_limit_req import GetIsolatedMarginRiskLimitReq
from .model_get_isolated_margin_risk_limit_resp import GetIsolatedMarginRiskLimitResp
from .model_get_margin_mode_req import GetMarginModeReq
from .model_get_margin_mode_resp import GetMarginModeResp
from .model_get_max_open_size_req import GetMaxOpenSizeReq
from .model_get_max_open_size_resp import GetMaxOpenSizeResp
from .model_get_max_withdraw_margin_req import GetMaxWithdrawMarginReq
from .model_get_max_withdraw_margin_resp import GetMaxWithdrawMarginResp
from .model_get_position_details_req import GetPositionDetailsReq
from .model_get_position_details_resp import GetPositionDetailsResp
from .model_get_position_list_req import GetPositionListReq
from .model_get_position_list_resp import GetPositionListResp
from .model_get_positions_history_req import GetPositionsHistoryReq
from .model_get_positions_history_resp import GetPositionsHistoryResp
from .model_modify_auto_deposit_status_req import ModifyAutoDepositStatusReq
from .model_modify_auto_deposit_status_resp import ModifyAutoDepositStatusResp
from .model_modify_isolated_margin_risk_limt_req import ModifyIsolatedMarginRiskLimtReq
from .model_modify_isolated_margin_risk_limt_resp import ModifyIsolatedMarginRiskLimtResp
from .model_modify_margin_leverage_req import ModifyMarginLeverageReq
from .model_modify_margin_leverage_resp import ModifyMarginLeverageResp
from .model_remove_isolated_margin_req import RemoveIsolatedMarginReq
from .model_remove_isolated_margin_resp import RemoveIsolatedMarginResp
from .model_switch_margin_mode_req import SwitchMarginModeReq
from .model_switch_margin_mode_resp import SwitchMarginModeResp
from typing_extensions import deprecated


class PositionsAPI(ABC):

    @abstractmethod
    def get_margin_mode(self, req: GetMarginModeReq,
                        **kwargs: Any) -> GetMarginModeResp:
        """
        summary: Get Margin Mode
        description: This interface can query the margin mode of the current symbol.
        documentation: https://www.kucoin.com/docs-new/api-3470259
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def switch_margin_mode(self, req: SwitchMarginModeReq,
                           **kwargs: Any) -> SwitchMarginModeResp:
        """
        summary: Switch Margin Mode
        description: This interface can modify the margin mode of the current symbol.
        documentation: https://www.kucoin.com/docs-new/api-3470262
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_max_open_size(self, req: GetMaxOpenSizeReq,
                          **kwargs: Any) -> GetMaxOpenSizeResp:
        """
        summary: Get Max Open Size
        description: Get Maximum Open Position Size.
        documentation: https://www.kucoin.com/docs-new/api-3470251
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_position_details(self, req: GetPositionDetailsReq,
                             **kwargs: Any) -> GetPositionDetailsResp:
        """
        summary: Get Position Details
        description: Get the position details of a specified position.
        documentation: https://www.kucoin.com/docs-new/api-3470252
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_position_list(self, req: GetPositionListReq,
                          **kwargs: Any) -> GetPositionListResp:
        """
        summary: Get Position List
        description: Get the position details of a specified position.
        documentation: https://www.kucoin.com/docs-new/api-3470253
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_positions_history(self, req: GetPositionsHistoryReq,
                              **kwargs: Any) -> GetPositionsHistoryResp:
        """
        summary: Get Positions History
        description: This interface can query position history information records.
        documentation: https://www.kucoin.com/docs-new/api-3470254
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_max_withdraw_margin(self, req: GetMaxWithdrawMarginReq,
                                **kwargs: Any) -> GetMaxWithdrawMarginResp:
        """
        summary: Get Max Withdraw Margin
        description: This interface can query the maximum amount of margin that the current position supports withdrawal.
        documentation: https://www.kucoin.com/docs-new/api-3470258
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 10      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_cross_margin_leverage(self, req: GetCrossMarginLeverageReq,
                                  **kwargs: Any) -> GetCrossMarginLeverageResp:
        """
        summary: Get Cross Margin Leverage
        description: This interface can query the current symbol’s cross-margin leverage multiple.
        documentation: https://www.kucoin.com/docs-new/api-3470260
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def modify_margin_leverage(self, req: ModifyMarginLeverageReq,
                               **kwargs: Any) -> ModifyMarginLeverageResp:
        """
        summary: Modify Cross Margin Leverage
        description: This interface can modify the current symbol’s cross-margin leverage multiple.
        documentation: https://www.kucoin.com/docs-new/api-3470261
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def add_isolated_margin(self, req: AddIsolatedMarginReq,
                            **kwargs: Any) -> AddIsolatedMarginResp:
        """
        summary: Add Isolated Margin
        description: Add Isolated Margin Manually.
        documentation: https://www.kucoin.com/docs-new/api-3470257
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 4       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def remove_isolated_margin(self, req: RemoveIsolatedMarginReq,
                               **kwargs: Any) -> RemoveIsolatedMarginResp:
        """
        summary: Remove Isolated Margin
        description: Remove Isolated Margin Manually.
        documentation: https://www.kucoin.com/docs-new/api-3470256
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 10      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_isolated_margin_risk_limit(
            self, req: GetIsolatedMarginRiskLimitReq,
            **kwargs: Any) -> GetIsolatedMarginRiskLimitResp:
        """
        summary: Get Isolated Margin Risk Limit
        description: This interface can be used to obtain information about risk limit level of a specific contract(Only valid for isolated Margin).
        documentation: https://www.kucoin.com/docs-new/api-3470263
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | PUBLIC  |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def modify_isolated_margin_risk_limt(
            self, req: ModifyIsolatedMarginRiskLimtReq,
            **kwargs: Any) -> ModifyIsolatedMarginRiskLimtResp:
        """
        summary: Modify Isolated Margin Risk Limit
        description: This interface can be used to obtain information about risk limit level of a specific contract(Only valid for isolated Margin).
        documentation: https://www.kucoin.com/docs-new/api-3470264
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def modify_auto_deposit_status(
            self, req: ModifyAutoDepositStatusReq,
            **kwargs: Any) -> ModifyAutoDepositStatusResp:
        """
        summary: Modify Isolated Margin Auto-Deposit Status
        description: This endpoint is only applicable to isolated margin and is no longer recommended. It is recommended to use cross margin instead.
        documentation: https://www.kucoin.com/docs-new/api-3470255
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | FUTURES |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | FUTURES |
        | API-RATE-LIMIT-POOL | FUTURES |
        | API-RATE-LIMIT      | 4       |
        +---------------------+---------+
        """
        pass


class PositionsAPIImpl(PositionsAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def get_margin_mode(self, req: GetMarginModeReq,
                        **kwargs: Any) -> GetMarginModeResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v2/position/getMarginMode", req,
                                   GetMarginModeResp(), False, **kwargs)

    def switch_margin_mode(self, req: SwitchMarginModeReq,
                           **kwargs: Any) -> SwitchMarginModeResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v2/position/changeMarginMode", req,
                                   SwitchMarginModeResp(), False, **kwargs)

    def get_max_open_size(self, req: GetMaxOpenSizeReq,
                          **kwargs: Any) -> GetMaxOpenSizeResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v2/getMaxOpenSize", req,
                                   GetMaxOpenSizeResp(), False, **kwargs)

    def get_position_details(self, req: GetPositionDetailsReq,
                             **kwargs: Any) -> GetPositionDetailsResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/position", req,
                                   GetPositionDetailsResp(), False, **kwargs)

    def get_position_list(self, req: GetPositionListReq,
                          **kwargs: Any) -> GetPositionListResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/positions", req,
                                   GetPositionListResp(), False, **kwargs)

    def get_positions_history(self, req: GetPositionsHistoryReq,
                              **kwargs: Any) -> GetPositionsHistoryResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/history-positions", req,
                                   GetPositionsHistoryResp(), False, **kwargs)

    def get_max_withdraw_margin(self, req: GetMaxWithdrawMarginReq,
                                **kwargs: Any) -> GetMaxWithdrawMarginResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/margin/maxWithdrawMargin", req,
                                   GetMaxWithdrawMarginResp(), False, **kwargs)

    def get_cross_margin_leverage(self, req: GetCrossMarginLeverageReq,
                                  **kwargs: Any) -> GetCrossMarginLeverageResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v2/getCrossUserLeverage", req,
                                   GetCrossMarginLeverageResp(), False,
                                   **kwargs)

    def modify_margin_leverage(self, req: ModifyMarginLeverageReq,
                               **kwargs: Any) -> ModifyMarginLeverageResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v2/changeCrossUserLeverage", req,
                                   ModifyMarginLeverageResp(), False, **kwargs)

    def add_isolated_margin(self, req: AddIsolatedMarginReq,
                            **kwargs: Any) -> AddIsolatedMarginResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/position/margin/deposit-margin",
                                   req, AddIsolatedMarginResp(), False,
                                   **kwargs)

    def remove_isolated_margin(self, req: RemoveIsolatedMarginReq,
                               **kwargs: Any) -> RemoveIsolatedMarginResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/margin/withdrawMargin", req,
                                   RemoveIsolatedMarginResp(), False, **kwargs)

    def get_isolated_margin_risk_limit(
            self, req: GetIsolatedMarginRiskLimitReq,
            **kwargs: Any) -> GetIsolatedMarginRiskLimitResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/contracts/risk-limit/{symbol}",
                                   req, GetIsolatedMarginRiskLimitResp(),
                                   False, **kwargs)

    def modify_isolated_margin_risk_limt(
            self, req: ModifyIsolatedMarginRiskLimtReq,
            **kwargs: Any) -> ModifyIsolatedMarginRiskLimtResp:
        return self.transport.call("futures", False, "POST",
                                   "/api/v1/position/risk-limit-level/change",
                                   req, ModifyIsolatedMarginRiskLimtResp(),
                                   False, **kwargs)

    def modify_auto_deposit_status(
            self, req: ModifyAutoDepositStatusReq,
            **kwargs: Any) -> ModifyAutoDepositStatusResp:
        return self.transport.call(
            "futures", False, "POST",
            "/api/v1/position/margin/auto-deposit-status", req,
            ModifyAutoDepositStatusResp(), False, **kwargs)
