# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetPositionsHistoryReq(BaseModel):
    """
    GetPositionsHistoryReq

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        from_ (int): Closing start time(ms) 
        to (int): Closing end time(ms) 
        limit (int): Number of requests per page, max 200, default 10 
        page_id (int): Current page number, default 1 
    """

    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    from_: Optional[int] = Field(default=None,
                                 description="Closing start time(ms) ",
                                 alias="from")
    to: Optional[int] = Field(default=None,
                              description="Closing end time(ms) ")
    limit: Optional[Annotated[int, Field(le=200, strict=True)]] = Field(
        default=10,
        description="Number of requests per page, max 200, default 10 ")
    page_id: Optional[int] = Field(
        default=1,
        description="Current page number, default 1 ",
        alias="pageId")

    __properties: ClassVar[List[str]] = [
        "symbol", "from", "to", "limit", "pageId"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetPositionsHistoryReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetPositionsHistoryReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "from":
            obj.get("from"),
            "to":
            obj.get("to"),
            "limit":
            obj.get("limit") if obj.get("limit") is not None else 10,
            "pageId":
            obj.get("pageId") if obj.get("pageId") is not None else 1
        })
        return _obj


class GetPositionsHistoryReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetPositionsHistoryReqBuilder:
        """
        Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_from_(self, value: int) -> GetPositionsHistoryReqBuilder:
        """
        Closing start time(ms) 
        """
        self.obj['from'] = value
        return self

    def set_to(self, value: int) -> GetPositionsHistoryReqBuilder:
        """
        Closing end time(ms) 
        """
        self.obj['to'] = value
        return self

    def set_limit(self, value: int) -> GetPositionsHistoryReqBuilder:
        """
        Number of requests per page, max 200, default 10 
        """
        self.obj['limit'] = value
        return self

    def set_page_id(self, value: int) -> GetPositionsHistoryReqBuilder:
        """
        Current page number, default 1 
        """
        self.obj['pageId'] = value
        return self

    def build(self) -> GetPositionsHistoryReq:
        return GetPositionsHistoryReq(**self.obj)
