# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetInterestHistoryItems(BaseModel):
    """
    GetInterestHistoryItems

    Attributes:
        currency (str): currency
        day_ratio (str): Daily interest rate
        interest_amount (str): Interest amount
        created_time (int): Interest Timestamp
    """

    currency: Optional[str] = Field(default=None, description="currency")
    day_ratio: Optional[str] = Field(default=None,
                                     description="Daily interest rate",
                                     alias="dayRatio")
    interest_amount: Optional[str] = Field(default=None,
                                           description="Interest amount",
                                           alias="interestAmount")
    created_time: Optional[int] = Field(default=None,
                                        description="Interest Timestamp",
                                        alias="createdTime")

    __properties: ClassVar[List[str]] = [
        "currency", "dayRatio", "interestAmount", "createdTime"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetInterestHistoryItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetInterestHistoryItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "dayRatio": obj.get("dayRatio"),
            "interestAmount": obj.get("interestAmount"),
            "createdTime": obj.get("createdTime")
        })
        return _obj
