# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class RepayReq(BaseModel):
    """
    RepayReq

    Attributes:
        currency (str): currency
        size (float): Borrow amount
        symbol (str): symbol, mandatory for isolated margin account
        is_isolated (bool): true-isolated, false-cross; default is false
        is_hf (bool): true: high frequency borrowing, false: low frequency borrowing; default false
    """

    currency: Optional[str] = Field(default=None, description="currency")
    size: Optional[float] = Field(default=None, description="Borrow amount")
    symbol: Optional[str] = Field(
        default=None,
        description="symbol, mandatory for isolated margin account")
    is_isolated: Optional[bool] = Field(
        default=False,
        description="true-isolated, false-cross; default is false",
        alias="isIsolated")
    is_hf: Optional[bool] = Field(
        default=False,
        description=
        "true: high frequency borrowing, false: low frequency borrowing; default false",
        alias="isHf")

    __properties: ClassVar[List[str]] = [
        "currency", "size", "symbol", "isIsolated", "isHf"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[RepayReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[RepayReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "size":
            obj.get("size"),
            "symbol":
            obj.get("symbol"),
            "isIsolated":
            obj.get("isIsolated")
            if obj.get("isIsolated") is not None else False,
            "isHf":
            obj.get("isHf") if obj.get("isHf") is not None else False
        })
        return _obj


class RepayReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> RepayReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_size(self, value: float) -> RepayReqBuilder:
        """
        Borrow amount
        """
        self.obj['size'] = value
        return self

    def set_symbol(self, value: str) -> RepayReqBuilder:
        """
        symbol, mandatory for isolated margin account
        """
        self.obj['symbol'] = value
        return self

    def set_is_isolated(self, value: bool) -> RepayReqBuilder:
        """
        true-isolated, false-cross; default is false
        """
        self.obj['isIsolated'] = value
        return self

    def set_is_hf(self, value: bool) -> RepayReqBuilder:
        """
        true: high frequency borrowing, false: low frequency borrowing; default false
        """
        self.obj['isHf'] = value
        return self

    def build(self) -> RepayReq:
        return RepayReq(**self.obj)
