# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_add_order_req import AddOrderReq
from .model_add_order_resp import AddOrderResp
from .model_add_order_test_req import AddOrderTestReq
from .model_add_order_test_resp import AddOrderTestResp
from .model_add_order_test_v1_req import AddOrderTestV1Req
from .model_add_order_test_v1_resp import AddOrderTestV1Resp
from .model_add_order_v1_req import AddOrderV1Req
from .model_add_order_v1_resp import AddOrderV1Resp
from .model_cancel_all_orders_by_symbol_req import CancelAllOrdersBySymbolReq
from .model_cancel_all_orders_by_symbol_resp import CancelAllOrdersBySymbolResp
from .model_cancel_order_by_client_oid_req import CancelOrderByClientOidReq
from .model_cancel_order_by_client_oid_resp import CancelOrderByClientOidResp
from .model_cancel_order_by_order_id_req import CancelOrderByOrderIdReq
from .model_cancel_order_by_order_id_resp import CancelOrderByOrderIdResp
from .model_get_closed_orders_req import GetClosedOrdersReq
from .model_get_closed_orders_resp import GetClosedOrdersResp
from .model_get_open_orders_req import GetOpenOrdersReq
from .model_get_open_orders_resp import GetOpenOrdersResp
from .model_get_order_by_client_oid_req import GetOrderByClientOidReq
from .model_get_order_by_client_oid_resp import GetOrderByClientOidResp
from .model_get_order_by_order_id_req import GetOrderByOrderIdReq
from .model_get_order_by_order_id_resp import GetOrderByOrderIdResp
from .model_get_symbols_with_open_order_req import GetSymbolsWithOpenOrderReq
from .model_get_symbols_with_open_order_resp import GetSymbolsWithOpenOrderResp
from .model_get_trade_history_req import GetTradeHistoryReq
from .model_get_trade_history_resp import GetTradeHistoryResp
from typing_extensions import deprecated


class OrderAPI(ABC):

    @abstractmethod
    def add_order(self, req: AddOrderReq, **kwargs: Any) -> AddOrderResp:
        """
        summary: Add Order
        description: Place order to the Cross-margin or Isolated-margin trading system, you can place two major types of orders: limit and market. Orders can only be placed if your account has sufficient funds. Once an order is placed, your funds will be put on hold for the duration of the order. The amount of funds on hold depends on the order type and parameters specified.
        documentation: https://www.kucoin.com/docs-new/api-3470204
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def add_order_test(self, req: AddOrderTestReq,
                       **kwargs: Any) -> AddOrderTestResp:
        """
        summary: Add Order Test
        description:  Order test endpoint, the request parameters and return parameters of this endpoint are exactly the same as the order endpoint, and can be used to verify whether the signature is correct and other operations. After placing an order, the order will not enter the matching system, and the order cannot be queried.
        documentation: https://www.kucoin.com/docs-new/api-3470205
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_order_by_order_id(self, req: CancelOrderByOrderIdReq,
                                 **kwargs: Any) -> CancelOrderByOrderIdResp:
        """
        summary: Cancel Order By OrderId
        description: This endpoint can be used to cancel a margin order by orderId. This endpoint only sends cancellation requests. The results of the requests must be obtained by checking the order status or subscribing to websocket.
        documentation: https://www.kucoin.com/docs-new/api-3470195
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_order_by_client_oid(
            self, req: CancelOrderByClientOidReq,
            **kwargs: Any) -> CancelOrderByClientOidResp:
        """
        summary: Cancel Order By ClientOid
        description: This endpoint can be used to cancel a margin order by clientOid. This endpoint only sends cancellation requests. The results of the requests must be obtained by checking the order status or subscribing to websocket.
        documentation: https://www.kucoin.com/docs-new/api-3470201
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def cancel_all_orders_by_symbol(
            self, req: CancelAllOrdersBySymbolReq,
            **kwargs: Any) -> CancelAllOrdersBySymbolResp:
        """
        summary: Cancel All Orders By Symbol
        description: This interface can cancel all open Margin orders by symbol This endpoint only sends cancellation requests. The results of the requests must be obtained by checking the order status or subscribing to websocket.
        documentation: https://www.kucoin.com/docs-new/api-3470197
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 10      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_symbols_with_open_order(
            self, req: GetSymbolsWithOpenOrderReq,
            **kwargs: Any) -> GetSymbolsWithOpenOrderResp:
        """
        summary: Get Symbols With Open Order
        description: This interface can query all Margin symbol that has active orders
        documentation: https://www.kucoin.com/docs-new/api-3470196
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 2       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_open_orders(self, req: GetOpenOrdersReq,
                        **kwargs: Any) -> GetOpenOrdersResp:
        """
        summary: Get Open Orders
        description: This interface is to obtain all Margin active order lists, and the return value of the active order interface is the paged data of all uncompleted order lists. The returned data is sorted in descending order according to the latest update time of the order.  After the user successfully places an order, the order is in Active state, and the user can use inOrderBook to determine whether the order has entered the order. Canceled or fully filled orders are marked as completed Done status.
        documentation: https://www.kucoin.com/docs-new/api-3470198
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 4       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_closed_orders(self, req: GetClosedOrdersReq,
                          **kwargs: Any) -> GetClosedOrdersResp:
        """
        summary: Get Closed Orders
        description: This interface is to obtain all Margin closed order lists, and the return value of the active order interface is the paged data of all uncompleted order lists. The returned data is sorted in descending order according to the latest update time of the order.  After the user successfully places an order, the order is in Active state, and the user can use inOrderBook to determine whether the order has entered the order. Canceled or fully filled orders are marked as completed Done status.
        documentation: https://www.kucoin.com/docs-new/api-3470199
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 10      |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_trade_history(self, req: GetTradeHistoryReq,
                          **kwargs: Any) -> GetTradeHistoryResp:
        """
        summary: Get Trade History
        description: This endpoint can be used to obtain a list of the latest Margin transaction details.  The returned data is sorted in descending order according to the latest update time of the order.
        documentation: https://www.kucoin.com/docs-new/api-3470200
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_order_by_order_id(self, req: GetOrderByOrderIdReq,
                              **kwargs: Any) -> GetOrderByOrderIdResp:
        """
        summary: Get Order By OrderId
        description: This endpoint can be used to obtain information for a single Margin order using the order id.  After the user successfully places an order, the order is in Active state, and the user can use inOrderBook to determine whether the order has entered the order. Canceled or fully filled orders are marked as completed Done status.
        documentation: https://www.kucoin.com/docs-new/api-3470202
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    def get_order_by_client_oid(self, req: GetOrderByClientOidReq,
                                **kwargs: Any) -> GetOrderByClientOidResp:
        """
        summary: Get Order By ClientOid
        description: This endpoint can be used to obtain information for a single Margin order using the client order id.  After the user successfully places an order, the order is in Active state, and the user can use inOrderBook to determine whether the order has entered the order. Canceled or fully filled orders are marked as completed Done status.
        documentation: https://www.kucoin.com/docs-new/api-3470203
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | GENERAL |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def add_order_v1(self, req: AddOrderV1Req,
                     **kwargs: Any) -> AddOrderV1Resp:
        """
        summary: Add Order - V1
        description: Place order to the Cross-margin or Isolated-margin trading system, you can place two major types of orders: limit and market. Orders can only be placed if your account has sufficient funds. Once an order is placed, your funds will be put on hold for the duration of the order. The amount of funds on hold depends on the order type and parameters specified.
        documentation: https://www.kucoin.com/docs-new/api-3470312
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def add_order_test_v1(self, req: AddOrderTestV1Req,
                          **kwargs: Any) -> AddOrderTestV1Resp:
        """
        summary: Add Order Test - V1
        description: Order test endpoint, the request parameters and return parameters of this endpoint are exactly the same as the order endpoint, and can be used to verify whether the signature is correct and other operations. After placing an order, the order will not enter the matching system, and the order cannot be queried.
        documentation: https://www.kucoin.com/docs-new/api-3470313
        +---------------------+---------+
        | Extra API Info      | Value   |
        +---------------------+---------+
        | API-DOMAIN          | SPOT    |
        | API-CHANNEL         | PRIVATE |
        | API-PERMISSION      | MARGIN  |
        | API-RATE-LIMIT-POOL | SPOT    |
        | API-RATE-LIMIT      | 5       |
        +---------------------+---------+
        """
        pass


class OrderAPIImpl(OrderAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def add_order(self, req: AddOrderReq, **kwargs: Any) -> AddOrderResp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v3/hf/margin/order", req,
                                   AddOrderResp(), False, **kwargs)

    def add_order_test(self, req: AddOrderTestReq,
                       **kwargs: Any) -> AddOrderTestResp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v3/hf/margin/order/test", req,
                                   AddOrderTestResp(), False, **kwargs)

    def cancel_order_by_order_id(self, req: CancelOrderByOrderIdReq,
                                 **kwargs: Any) -> CancelOrderByOrderIdResp:
        return self.transport.call("spot", False, "DELETE",
                                   "/api/v3/hf/margin/orders/{orderId}", req,
                                   CancelOrderByOrderIdResp(), False, **kwargs)

    def cancel_order_by_client_oid(
            self, req: CancelOrderByClientOidReq,
            **kwargs: Any) -> CancelOrderByClientOidResp:
        return self.transport.call(
            "spot", False, "DELETE",
            "/api/v3/hf/margin/orders/client-order/{clientOid}", req,
            CancelOrderByClientOidResp(), False, **kwargs)

    def cancel_all_orders_by_symbol(
            self, req: CancelAllOrdersBySymbolReq,
            **kwargs: Any) -> CancelAllOrdersBySymbolResp:
        return self.transport.call("spot", False, "DELETE",
                                   "/api/v3/hf/margin/orders", req,
                                   CancelAllOrdersBySymbolResp(), False,
                                   **kwargs)

    def get_symbols_with_open_order(
            self, req: GetSymbolsWithOpenOrderReq,
            **kwargs: Any) -> GetSymbolsWithOpenOrderResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/hf/margin/order/active/symbols",
                                   req, GetSymbolsWithOpenOrderResp(), False,
                                   **kwargs)

    def get_open_orders(self, req: GetOpenOrdersReq,
                        **kwargs: Any) -> GetOpenOrdersResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/hf/margin/orders/active", req,
                                   GetOpenOrdersResp(), False, **kwargs)

    def get_closed_orders(self, req: GetClosedOrdersReq,
                          **kwargs: Any) -> GetClosedOrdersResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/hf/margin/orders/done", req,
                                   GetClosedOrdersResp(), False, **kwargs)

    def get_trade_history(self, req: GetTradeHistoryReq,
                          **kwargs: Any) -> GetTradeHistoryResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/hf/margin/fills", req,
                                   GetTradeHistoryResp(), False, **kwargs)

    def get_order_by_order_id(self, req: GetOrderByOrderIdReq,
                              **kwargs: Any) -> GetOrderByOrderIdResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/hf/margin/orders/{orderId}", req,
                                   GetOrderByOrderIdResp(), False, **kwargs)

    def get_order_by_client_oid(self, req: GetOrderByClientOidReq,
                                **kwargs: Any) -> GetOrderByClientOidResp:
        return self.transport.call(
            "spot", False, "GET",
            "/api/v3/hf/margin/orders/client-order/{clientOid}", req,
            GetOrderByClientOidResp(), False, **kwargs)

    def add_order_v1(self, req: AddOrderV1Req,
                     **kwargs: Any) -> AddOrderV1Resp:
        return self.transport.call("spot", False,
                                   "POST", "/api/v1/margin/order", req,
                                   AddOrderV1Resp(), False, **kwargs)

    def add_order_test_v1(self, req: AddOrderTestV1Req,
                          **kwargs: Any) -> AddOrderTestV1Resp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v1/margin/order/test", req,
                                   AddOrderTestV1Resp(), False, **kwargs)
