# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetTradeHistoryData(BaseModel):
    """
    GetTradeHistoryData

    Attributes:
        sequence (str): Sequence number
        price (str): Filled price
        size (str): Filled amount
        side (SideEnum): Filled side, The trade side indicates the taker order side. A taker order is the order that was matched with orders opened on the order book.
        time (int): Filled timestamp(nanosecond)
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    sequence: Optional[str] = Field(default=None,
                                    description="Sequence number")
    price: Optional[str] = Field(default=None, description="Filled price")
    size: Optional[str] = Field(default=None, description="Filled amount")
    side: Optional[SideEnum] = Field(
        default=None,
        description=
        "Filled side, The trade side indicates the taker order side. A taker order is the order that was matched with orders opened on the order book."
    )
    time: Optional[int] = Field(default=None,
                                description="Filled timestamp(nanosecond)")

    __properties: ClassVar[List[str]] = [
        "sequence", "price", "size", "side", "time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTradeHistoryData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetTradeHistoryData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sequence": obj.get("sequence"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "side": obj.get("side"),
            "time": obj.get("time")
        })
        return _obj
