# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class BatchCancelOrderOldReq(BaseModel):
    """
    BatchCancelOrderOldReq

    Attributes:
        symbol (str): symbol
        trade_type (TradeTypeEnum): The type of trading :TRADE(Spot Trading), MARGIN_TRADE(Cross Margin Trading), MARGIN_ISOLATED_TRADE(Isolated Margin Trading), and the default is TRADE to cancel the spot trading orders.
    """

    class TradeTypeEnum(Enum):
        """
        Attributes:
            TRADE: Spot Trading
            MARGIN_TRADE: Cross Margin Trading
            MARGIN_ISOLATED_TRADE: Isolated Margin Trading
        """
        TRADE = 'TRADE'
        MARGIN_TRADE = 'MARGIN_TRADE'
        MARGIN_ISOLATED_TRADE = 'MARGIN_ISOLATED_TRADE'

    symbol: Optional[str] = Field(default=None, description="symbol")
    trade_type: Optional[TradeTypeEnum] = Field(
        default=TradeTypeEnum.TRADE,
        description=
        "The type of trading :TRADE(Spot Trading), MARGIN_TRADE(Cross Margin Trading), MARGIN_ISOLATED_TRADE(Isolated Margin Trading), and the default is TRADE to cancel the spot trading orders.",
        alias="tradeType")

    __properties: ClassVar[List[str]] = ["symbol", "tradeType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[BatchCancelOrderOldReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[BatchCancelOrderOldReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "tradeType":
            obj.get("tradeType") if obj.get("tradeType") is not None else
            BatchCancelOrderOldReq.TradeTypeEnum.TRADE
        })
        return _obj


class BatchCancelOrderOldReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> BatchCancelOrderOldReqBuilder:
        """
        symbol
        """
        self.obj['symbol'] = value
        return self

    def set_trade_type(
        self, value: BatchCancelOrderOldReq.TradeTypeEnum
    ) -> BatchCancelOrderOldReqBuilder:
        """
        The type of trading :TRADE(Spot Trading), MARGIN_TRADE(Cross Margin Trading), MARGIN_ISOLATED_TRADE(Isolated Margin Trading), and the default is TRADE to cancel the spot trading orders.
        """
        self.obj['tradeType'] = value
        return self

    def build(self) -> BatchCancelOrderOldReq:
        return BatchCancelOrderOldReq(**self.obj)
