# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class BatchCancelStopOrderReq(BaseModel):
    """
    BatchCancelStopOrderReq

    Attributes:
        symbol (str): Cancel the open order for the specified symbol
        trade_type (str): The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE
        order_ids (str): Comma seperated order IDs.
    """

    symbol: Optional[str] = Field(
        default=None,
        description="Cancel the open order for the specified symbol")
    trade_type: Optional[str] = Field(
        default=None,
        description=
        "The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE",
        alias="tradeType")
    order_ids: Optional[str] = Field(default=None,
                                     description="Comma seperated order IDs.",
                                     alias="orderIds")

    __properties: ClassVar[List[str]] = ["symbol", "tradeType", "orderIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[BatchCancelStopOrderReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[BatchCancelStopOrderReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "tradeType": obj.get("tradeType"),
            "orderIds": obj.get("orderIds")
        })
        return _obj


class BatchCancelStopOrderReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> BatchCancelStopOrderReqBuilder:
        """
        Cancel the open order for the specified symbol
        """
        self.obj['symbol'] = value
        return self

    def set_trade_type(self, value: str) -> BatchCancelStopOrderReqBuilder:
        """
        The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE
        """
        self.obj['tradeType'] = value
        return self

    def set_order_ids(self, value: str) -> BatchCancelStopOrderReqBuilder:
        """
        Comma seperated order IDs.
        """
        self.obj['orderIds'] = value
        return self

    def build(self) -> BatchCancelStopOrderReq:
        return BatchCancelStopOrderReq(**self.obj)
