# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_oco_order_detail_by_order_id_orders import GetOcoOrderDetailByOrderIdOrders
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetOcoOrderDetailByOrderIdResp(BaseModel, Response):
    """
    GetOcoOrderDetailByOrderIdResp

    Attributes:
        order_id (str): The unique order id generated by the trading system,which can be used later for further actions such as canceling the order.
        symbol (str): symbol
        client_oid (str): Client Order Id
        order_time (int): Order placement time, milliseconds
        status (str): Order status: NEW: New, DONE: Completed, TRIGGERED: Triggered, CANCELLED: Cancelled
        orders (list[GetOcoOrderDetailByOrderIdOrders]): 
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    order_id: Optional[str] = Field(
        default=None,
        description=
        "The unique order id generated by the trading system,which can be used later for further actions such as canceling the order.",
        alias="orderId")
    symbol: Optional[str] = Field(default=None, description="symbol")
    client_oid: Optional[str] = Field(default=None,
                                      description="Client Order Id",
                                      alias="clientOid")
    order_time: Optional[int] = Field(
        default=None,
        description="Order placement time, milliseconds",
        alias="orderTime")
    status: Optional[str] = Field(
        default=None,
        description=
        "Order status: NEW: New, DONE: Completed, TRIGGERED: Triggered, CANCELLED: Cancelled"
    )
    orders: Optional[List[GetOcoOrderDetailByOrderIdOrders]] = None

    __properties: ClassVar[List[str]] = [
        "orderId", "symbol", "clientOid", "orderTime", "status", "orders"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetOcoOrderDetailByOrderIdResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item_orders in self.orders:
                if _item_orders:
                    _items.append(_item_orders.to_dict())
            _dict['orders'] = _items
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetOcoOrderDetailByOrderIdResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId":
            obj.get("orderId"),
            "symbol":
            obj.get("symbol"),
            "clientOid":
            obj.get("clientOid"),
            "orderTime":
            obj.get("orderTime"),
            "status":
            obj.get("status"),
            "orders": [
                GetOcoOrderDetailByOrderIdOrders.from_dict(_item)
                for _item in obj["orders"]
            ] if obj.get("orders") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
