# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated


class GetOrdersListOldReq(BaseModel):
    """
    GetOrdersListOldReq

    Attributes:
        symbol (str): symbol
        status (StatusEnum): active or done(done as default), Only list orders with a specific status .
        side (SideEnum): buy or sell
        type (TypeEnum): limit, market, limit_stop or market_stop
        trade_type (TradeTypeEnum): The type of trading:TRADE - Spot Trading(TRADE as default), MARGIN_TRADE - Cross Margin Trading, MARGIN_ISOLATED_TRADE - Isolated Margin Trading.
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current request page.
        page_size (int): Number of results per request. Minimum is 10, maximum is 500.
    """

    class StatusEnum(Enum):
        """
        Attributes:
            ACTIVE: Active order
            DONE: Done orders
        """
        ACTIVE = 'active'
        DONE = 'done'

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: limit
            MARKET: market
            LIMIT_STOP: limit_stop
            MARKET_STOP: market_stop
        """
        LIMIT = 'limit'
        MARKET = 'market'
        LIMIT_STOP = 'limit_stop'
        MARKET_STOP = 'market_stop'

    class TradeTypeEnum(Enum):
        """
        Attributes:
            TRADE: Spot Trading
            MARGIN_TRADE: Cross Margin Trading
            MARGIN_ISOLATED_TRADE: Isolated Margin Trading
        """
        TRADE = 'TRADE'
        MARGIN_TRADE = 'MARGIN_TRADE'
        MARGIN_ISOLATED_TRADE = 'MARGIN_ISOLATED_TRADE'

    symbol: Optional[str] = Field(default=None, description="symbol")
    status: Optional[StatusEnum] = Field(
        default=StatusEnum.DONE,
        description=
        "active or done(done as default), Only list orders with a specific status ."
    )
    side: Optional[SideEnum] = Field(default=None, description="buy or sell")
    type: Optional[TypeEnum] = Field(
        default=None, description="limit, market, limit_stop or market_stop")
    trade_type: Optional[TradeTypeEnum] = Field(
        default=TradeTypeEnum.TRADE,
        description=
        "The type of trading:TRADE - Spot Trading(TRADE as default), MARGIN_TRADE - Cross Margin Trading, MARGIN_ISOLATED_TRADE - Isolated Margin Trading.",
        alias="tradeType")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(default=1,
                                        description="Current request page.",
                                        alias="currentPage")
    page_size: Optional[Annotated[
        int, Field(le=500, strict=True, ge=10)]] = Field(
            default=50,
            description=
            "Number of results per request. Minimum is 10, maximum is 500.",
            alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "symbol", "status", "side", "type", "tradeType", "startAt", "endAt",
        "currentPage", "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetOrdersListOldReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetOrdersListOldReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "status":
            obj.get("status") if obj.get("status") is not None else
            GetOrdersListOldReq.StatusEnum.DONE,
            "side":
            obj.get("side"),
            "type":
            obj.get("type"),
            "tradeType":
            obj.get("tradeType") if obj.get("tradeType") is not None else
            GetOrdersListOldReq.TradeTypeEnum.TRADE,
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 50
        })
        return _obj


class GetOrdersListOldReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetOrdersListOldReqBuilder:
        """
        symbol
        """
        self.obj['symbol'] = value
        return self

    def set_status(
            self, value: GetOrdersListOldReq.StatusEnum
    ) -> GetOrdersListOldReqBuilder:
        """
        active or done(done as default), Only list orders with a specific status .
        """
        self.obj['status'] = value
        return self

    def set_side(
            self,
            value: GetOrdersListOldReq.SideEnum) -> GetOrdersListOldReqBuilder:
        """
        buy or sell
        """
        self.obj['side'] = value
        return self

    def set_type(
            self,
            value: GetOrdersListOldReq.TypeEnum) -> GetOrdersListOldReqBuilder:
        """
        limit, market, limit_stop or market_stop
        """
        self.obj['type'] = value
        return self

    def set_trade_type(
        self, value: GetOrdersListOldReq.TradeTypeEnum
    ) -> GetOrdersListOldReqBuilder:
        """
        The type of trading:TRADE - Spot Trading(TRADE as default), MARGIN_TRADE - Cross Margin Trading, MARGIN_ISOLATED_TRADE - Isolated Margin Trading.
        """
        self.obj['tradeType'] = value
        return self

    def set_start_at(self, value: int) -> GetOrdersListOldReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetOrdersListOldReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetOrdersListOldReqBuilder:
        """
        Current request page.
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetOrdersListOldReqBuilder:
        """
        Number of results per request. Minimum is 10, maximum is 500.
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetOrdersListOldReq:
        return GetOrdersListOldReq(**self.obj)
